<?php $__env->startSection('pageHeading'); ?>
  <?php echo e(__('Home')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('metaKeywords'); ?>
  <?php if(!empty($seoInfo)): ?>
    <?php echo e($seoInfo->meta_keyword_home); ?>

  <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('metaDescription'); ?>
  <?php if(!empty($seoInfo)): ?>
    <?php echo e($seoInfo->meta_description_home); ?>

  <?php endif; ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
  <!-- Hero section start-->
  <section class="hero-banner hero-banner_v1 header-next">
    <div class="container-fluid  px-lg-0">
      <div class="row align-items-center">
        <div class="col-lg-7">
          <div class="fluid-left">
            <div class="banner-content mb-30">
              <h1 class="title mb-20 fw-normal">
                <?php echo e(!empty($sectionContent->hero_section_title) ? $sectionContent->hero_section_title : __('Discover the Freedom of Hourly Hotel Bookings for Relax')); ?>

              </h1>
              <p class="text">
                <?php echo e(!empty($sectionContent->hero_section_subtitle) ? $sectionContent->hero_section_subtitle : ''); ?></p>
            </div>
            <div class="banner-filter-form mb-40">
              <div class="form-wrapper p-20 border radius-md">
                <form action="<?php echo e(route('frontend.rooms')); ?>" id="searchForm2" method="GET">
                  <div class="grid">
                    <div class="item">
                      <div class="form-group">
                        <label for="place"><?php echo e(__('Where')); ?>?</label>
                        <div class="form-block">
                          <div class="icon">
                            <i class="fas fa-map-marker-alt"></i>
                          </div>
                          <input type="text" name="location" class="form-control"
                            placeholder="<?php echo e(__('Enter Address')); ?>" id="search-address">
                          <?php if($basicInfo->google_map_api_key_status == 1): ?>
                            <button type="button" class="btn btn-primary current-location-btn mt-2 btn-sm float-right"
                              onclick="getCurrentLocationHome()">
                              <i class="fas fa-location"></i>
                            </button>
                          <?php endif; ?>
                        </div>
                      </div>
                    </div>
                    <div class="item">
                      <div class="form-group">
                        <label for="date"><?php echo e(__('When')); ?>?</label>
                        <div class="form-block">
                          <div class="icon">
                            <i class="far fa-calendar-alt"></i>
                          </div>
                          <input type="text" class="form-control " id="checkInDate" name="checkInDates"
                            placeholder="MM/DD/YYYY"readonly />
                        </div>
                      </div>
                    </div>
                    <div class="item">
                      <div class="form-group">
                        <label for="date"><?php echo e(__('Time')); ?>?</label>
                        <div class="form-block">
                          <div class="icon">
                            <i class="far fa-clock"></i>
                          </div>
                          <input type="text" class="form-control " id="checkInTime" name="checkInTimes"
                            placeholder="HH:MM:A" readonly />
                        </div>
                      </div>
                    </div>

                    <div class="item text-md-end">
                      <button class="btn btn-primary radius-sm" id="searchBtn2" type="button" aria-label="button">
                        <i class="far fa-search"></i>
                      </button>
                    </div>
                  </div>
                </form>
              </div>
            </div>
            <div class="scroll-down mb-40">
              <a href="#scrollDiv" class="btn-icon-text" title="<?php echo e(__('Btn')); ?>" target="_self">
                <span><i class="far fa-long-arrow-down"></i></span>
                <span><?php echo e(__('SCROLL DOWN')); ?></span>
              </a>
            </div>
          </div>
        </div>
        <div class="col-lg-5">
          <div class="banner-img mb-40">
            <img class="lazyload" data-src="<?php echo e(asset('assets/img/homepage/' . $images->hero_section_image)); ?>"
              alt="Image">
          </div>
        </div>
      </div>
    </div>
    <!-- Bg shape -->
    <div class="bg-shape">
      <img class="lazyload" data-src="<?php echo e(asset('assets/img/shape/bg-shape-1.png')); ?>" alt="Image">
    </div>
  </section>
  <!-- Hero section end -->

  <?php if(count($after_hero) > 0): ?>
    <?php $__currentLoopData = $after_hero; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cusHero): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <?php if(isset($homecusSec[$cusHero->id])): ?>
        <?php if($homecusSec[$cusHero->id] == 1): ?>
          <?php
            $cusHeroContent = App\Models\HomePage\CustomSectionContent::where('custom_section_id', $cusHero->id)
                ->where('language_id', $currentLanguageInfo->id)
                ->first();
          ?>
          <?php echo $__env->make('frontend.home.custom-section', ['data' => $cusHeroContent], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>
      <?php endif; ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
  <?php endif; ?>
  <!-- CITY-area start -->
  <?php if($secInfo->city_section_status == 1): ?>
    <section class="category-area category-area_v1 pt-60 pb-70" id="scrollDiv">
      <div class="container">
        <div class="row">
          <div class="col-12">
            <div class="section-title title-inline mb-50" data-aos="fade-up">
              <h2 class="title fw-normal">
                <?php echo e(!empty($sectionContent->city_section_title) ? $sectionContent->city_section_title : ''); ?></h2>
            </div>
          </div>
          <div class="col-12">
            <div class="swiper category-slider" id="category-slider-1" data-slides-per-view="4" data-swiper-loop="true"
              data-swiper-space="0">
              <div class="swiper-wrapper">
                <?php $__currentLoopData = $cities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $city): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <div class="swiper-slide">
                    <div class="card mb-30">
                      <div class="card_img">
                        <a href="<?php echo e(route('frontend.hotels', ['city' => $city->id])); ?>" title="<?php echo e($city->name); ?>"
                          target="_self" class="lazy-container ratio ratio-1-2 radius-md">
                          <img class="lazyload"
                            data-src="<?php echo e(asset('assets/img/location/city/' . $city->feature_image)); ?>" alt="Image">
                        </a>
                      </div>
                      <div class="card_content">
                        <a href="<?php echo e(route('frontend.hotels', ['city' => $city->id])); ?>"
                          class="btn btn-lg btn-secondary radius-sm shadow-md icon-end" title="<?php echo e($city->name); ?>"
                          target="_self">
                          <span><?php echo e($city->name); ?></span>
                          <i
                            class="fal <?php echo e($currentLanguageInfo->direction == 1 ? 'fa-long-arrow-left' : 'fa-long-arrow-right'); ?>"></i>
                        </a>
                      </div>
                    </div>
                  </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </div>
              <!-- If we need pagination -->
              <div class="swiper-pagination position-static mb-30" id="category-slider-1-pagination"></div>
            </div>
          </div>
        </div>
      </div>
    </section>
  <?php endif; ?>
  <!-- CITY-area end -->

  <?php if(count($after_city) > 0): ?>
    <?php $__currentLoopData = $after_city; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cusCity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <?php if(isset($homecusSec[$cusCity->id])): ?>
        <?php if($homecusSec[$cusCity->id] == 1): ?>
          <?php
            $cusCityContent = App\Models\HomePage\CustomSectionContent::where('custom_section_id', $cusCity->id)
                ->where('language_id', $currentLanguageInfo->id)
                ->first();
          ?>
          <?php echo $__env->make('frontend.home.custom-section', ['data' => $cusCityContent], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>
      <?php endif; ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
  <?php endif; ?>

  <!-- About-area start -->
  <?php if($secInfo->featured_section_status == 1): ?>
    <section class="about-area about-area_v1 pb-60">
      <div class="container-fluid  px-lg-0">
        <div class="row align-items-center gx-xl-5" data-aos="fade-up">
          <div class="col-lg-6">
            <div class="image mb-40">
              <img class="lazyload blur-up"
                data-src="<?php echo e(asset('assets/img/homepage/' . $images->feature_section_image)); ?>" alt="Image">
            </div>
          </div>
          <div class="col-lg-6">
            <div class="content-title fluid-right pb-20">
              <h2 class="title fw-normal mb-20">
                <?php echo e($sectionContent ? $sectionContent->featured_section_title : __('Your Ultimate Hourly Hotel Booking Solution')); ?>

              </h2>
              <p>
                <?php echo e($sectionContent ? $sectionContent->featured_section_text : ''); ?>

              </p>
              <div class="info-list mt-30">
                <?php $__currentLoopData = $features; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <div class="card mb-20">
                    <div class="card_icon">
                      <img class="lazyload" data-src="<?php echo e(asset('assets/img/feature/' . $feature->image)); ?>"
                        alt="Image">
                    </div>
                    <div class="card_content">
                      <span class="h3 lh-1 mb-1 fw-normal"><?php echo e($feature->title); ?></span>
                      <p class="card_text"><?php echo e($feature->subtitle); ?></p>
                    </div>
                  </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  <?php endif; ?>
  <!-- About-area end -->

  <?php if(count($after_featured) > 0): ?>
    <?php $__currentLoopData = $after_featured; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cusFeature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <?php if(isset($homecusSec[$cusFeature->id])): ?>
        <?php if($homecusSec[$cusFeature->id] == 1): ?>
          <?php
            $cusFeatureContent = App\Models\HomePage\CustomSectionContent::where('custom_section_id', $cusFeature->id)
                ->where('language_id', $currentLanguageInfo->id)
                ->first();
          ?>
          <?php echo $__env->make('frontend.home.custom-section', ['data' => $cusFeatureContent], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>
      <?php endif; ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
  <?php endif; ?>

  <!-- room-area start -->
  <?php if($secInfo->featured_room_section_status == 1): ?>
    <section class="product-area featured-product pb-75">
      <div class="container">
        <div class="row">
          <div class="col-12" data-aos="fade-up">
            <div class="section-title title-center mb-50">
              <h2 class="title fw-normal mt-0">
                <?php echo e(!empty($sectionContent->featured_room_section_title) ? $sectionContent->featured_room_section_title : __('Popular Hotel Room')); ?>

              </h2>
            </div>
          </div>
          <div class="col-12" data-aos="fade-up">
            <div class="row">
              <?php if(count($room_contents) < 1): ?>
                <div class="p-3 text-center bg-light radius-md">
                  <h6 class="mb-0"><?php echo e(__('NO FEATURED ROOM FOUND')); ?></h6>
                </div>
              <?php else: ?>
                <?php $__currentLoopData = $room_contents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $room): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <div class="col-xl-4 col-md-6">
                    <div class="product-default border radius-md mb-25">
                      <figure class="product_img">
                        <a href="<?php echo e(route('frontend.room.details', ['slug' => $room->slug, 'id' => $room->id])); ?>"
                          target="_self" title="<?php echo e(__('Link')); ?>" class="lazy-container ratio ratio-2-3 radius-sm">
                          <img class="lazyload"
                            src="<?php echo e(asset('assets/img/room/featureImage/' . $room->feature_image)); ?>" alt="Room">
                        </a>
                        <?php if(Auth::guard('web')->check()): ?>
                          <?php
                            $user_id = Auth::guard('web')->user()->id;
                            $checkWishList = checkroomWishList($room->id, $user_id);
                          ?>
                        <?php else: ?>
                          <?php
                            $checkWishList = false;
                          ?>
                        <?php endif; ?>

                        <a href="<?php echo e($checkWishList == false ? route('addto.wishlist.room', $room->id) : route('remove.wishlist.room', $room->id)); ?>"
                          class="btn btn-icon radius-sm <?php echo e($checkWishList == false ? '' : 'active'); ?>"
                          data-tooltip="tooltip" data-bs-placement="top"
                          title="<?php echo e($checkWishList == false ? __('Save to Wishlist') : __('Saved')); ?>">
                          <i class="fal fa-heart"></i>
                        </a>
                        <div class="rank-star">
                          <?php for($i = 0; $i < $room->stars; $i++): ?>
                            <i class="fas fa-star"></i>
                          <?php endfor; ?>
                        </div>
                      </figure>
                      <div class="product_details">
                        <div class="p-20">
                          <div class="product_title">
                            <h4 class="title lc-1 mb-0 fw-normal">
                              <a href="<?php echo e(route('frontend.room.details', ['slug' => $room->slug, 'id' => $room->id])); ?>"
                                target="_self" title="<?php echo e(__('Link')); ?>"><?php echo e($room->title); ?></a>
                            </h4>
                          </div>
                          <?php
                            $city = null;
                            $State = null;
                            $country = null;

                            if ($room->city_id) {
                                $city = App\Models\Location\City::Where('id', $room->city_id)->first()->name;
                            }
                            if ($room->state_id) {
                                $State = App\Models\Location\State::Where('id', $room->state_id)->first()->name;
                            }
                            if ($room->country_id) {
                                $country = App\Models\Location\Country::Where('id', $room->country_id)->first()->name;
                            }

                          ?>

                          <div class=" list-unstyled mt-15">
                            <li class="icon-start location mb-2">
                              <i class="fal fa-map-marker-alt"></i>
                              <span>
                                <?php echo e(@$city); ?><?php if(@$State): ?>
                                  , <?php echo e($State); ?>

                                  <?php endif; ?> <?php if(@$country): ?>
                                    , <?php echo e($country); ?>

                                  <?php endif; ?>
                              </span>
                            </li>
                            <li>
                              <div class="ratings"dir="<?php echo e($currentLanguageInfo->direction == 1 ? 'rtl' : ''); ?>">
                                <div class="product-ratings rate text-xsm">
                                  <div class="rating" style="width: <?php echo e($room->average_rating * 20); ?>%;"></div>
                                </div>
                                <span>
                                  <?php echo e(number_format($room->average_rating, 2)); ?>

                                  (<?php echo e(totalRoomReview($room->id)); ?>

                                  <?php echo e(totalRoomReview($room->id) > 1 ? __('Reviews') : __('Review')); ?>)
                                </span>
                              </div>
                            </li>
                          </div>
                          <div class="product_author mt-15">
                            <a class="d-flex align-items-center gap-1"
                              href="<?php echo e(route('frontend.hotel.details', ['slug' => $room->hotelSlug, 'id' => $room->hotelId])); ?>"
                              target="_self" title="<?php echo e(__('Link')); ?>">
                              <img class="lazyload blur-up"
                                src="<?php echo e(asset('assets/img/hotel/logo/' . $room->hotelImage)); ?>"alt="<?php echo e(__('Image')); ?>">
                              <span class="underline lc-1" data-tooltip="tooltip" data-bs-placement="bottom"
                                aria-label="<?php echo e($room->hotelName); ?>" data-bs-original-title="<?php echo e($room->hotelName); ?>"
                                aria-describedby="tooltip">
                                <?php echo e($room->hotelName); ?>

                              </span>
                            </a>
                          </div>
                          <?php
                            $amenities = json_decode($room->amenities);
                            $totalAmenities = count($amenities);
                            $displayCount = 5;
                          ?>

                          <ul class="product-icon_list mt-15 list-unstyled">

                            <?php $__currentLoopData = $amenities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $amenitie): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                              <?php
                                if ($index >= $displayCount) {
                                    break;
                                }
                                $amin = App\Models\Amenitie::find($amenitie);
                              ?>
                              <li class="list-item" data-tooltip="tooltip" data-bs-placement="bottom"
                                aria-label="<?php echo e($amin->title); ?>" data-bs-original-title="<?php echo e($amin->title); ?>"
                                aria-describedby="tooltip"><i class="<?php echo e($amin->icon); ?>"></i></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            <?php if($totalAmenities > $displayCount): ?>
                              <li class="more_item_show_btn">
                                (+<?php echo e($totalAmenities - $displayCount); ?><i class="fas fa-ellipsis-h"></i>)
                                <div class="more_items_icons">
                                  <?php $__currentLoopData = $amenities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $amenitie): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                      if ($index < $displayCount) {
                                          continue;
                                      }
                                      $amin = App\Models\Amenitie::find($amenitie);
                                    ?>
                                    <a data-tooltip="tooltip" data-bs-placement="bottom"
                                      aria-label="<?php echo e($amin->title); ?>" data-bs-original-title="<?php echo e($amin->title); ?>"
                                      aria-describedby="tooltip" href="#"><i class="<?php echo e($amin->icon); ?>"
                                        title="<?php echo e($amin->title); ?>"></i></a>
                                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                              </li>
                            <?php endif; ?>
                          </ul>
                        </div>
                        <div class="product_bottom p-20 border-top text-center">
                          <ul class="product-price_list list-unstyled">
                            <?php
                              $prices = App\Models\HourlyRoomPrice::where('room_id', $room->id)
                                  ->where('hourly_room_prices.price', '!=', null)
                                  ->join('booking_hours', 'hourly_room_prices.hour_id', '=', 'booking_hours.id')
                                  ->orderBy('booking_hours.serial_number')
                                  ->select('hourly_room_prices.*', 'booking_hours.serial_number')
                                  ->get();
                            ?>
                            <?php $__currentLoopData = $prices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $price): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                              <li class="radius-sm">
                                <span class="h6 mb-1"><?php echo e(symbolPrice($price->price)); ?></span>
                                <span><?php echo e($price->hour); ?> <?php echo e(__('Hrs')); ?></span>
                              </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                          </ul>
                        </div>
                      </div>
                    </div>
                    <!-- product-default -->
                  </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              <?php endif; ?>
            </div>
          </div>
        </div>
      </div>
    </section>
  <?php endif; ?>
  <!-- room-area end -->


  <?php if(count($after_featured_room) > 0): ?>
    <?php $__currentLoopData = $after_featured_room; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cusFeatureRoom): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <?php if(isset($homecusSec[$cusFeatureRoom->id])): ?>
        <?php if($homecusSec[$cusFeatureRoom->id] == 1): ?>
          <?php
            $cusFeatureRoomContent = App\Models\HomePage\CustomSectionContent::where(
                'custom_section_id',
                $cusFeatureRoom->id,
            )
                ->where('language_id', $currentLanguageInfo->id)
                ->first();
          ?>
          <?php echo $__env->make('frontend.home.custom-section', ['data' => $cusFeatureRoomContent], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>
      <?php endif; ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
  <?php endif; ?>

  <!-- Counter-area start -->
  <?php if($secInfo->counter_section_status == 1): ?>
    <div class="counter-area counter-area_v1 py-4 bg-img bg-cover z-1"
      data-bg-img="<?php echo e(asset('assets/img/homepage/' . $images->counter_section_image)); ?>">
      <div class="overlay opacity-60"></div>
      <div class="container">
        <div class="row">
          <div class="col-lg-6">
            <div class="row" data-aos="fade-up">
              <?php $__currentLoopData = $counters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $counter): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-sm-6 item">
                  <div class="card radius-md border text-center p-30">
                    <div class="card_icon mb-20">
                      <img class="lazyload" data-src="<?php echo e(asset('assets/img/counter/' . $counter->image)); ?>"
                        alt="Image">
                    </div>
                    <div class="card_content">
                      <h2 class="card_title mb-15">
                        <span class="counter"><?php echo e($counter->amount); ?></span>+
                      </h2>
                      <p class="card_text font-lg lh-1">
                        <?php echo e($counter->title); ?>

                      </p>
                    </div>
                  </div>
                </div>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
          </div>
          <div class="col-lg-6">
            <div class="video-btn-parent z-2 h-100">
              <?php if(@$sectionContent->counter_section_video_link): ?>
                <a href="<?php echo e($sectionContent->counter_section_video_link); ?>"
                  class="video-btn video-btn-white youtube-popup" title="<?php echo e(__('Play Video')); ?>">
                  <i class="fas fa-play"></i>
                </a>
              <?php endif; ?>

            </div>
          </div>
        </div>
      </div>
    </div>
  <?php endif; ?>
  <!-- Counter-area end -->

  <?php if(count($after_counter) > 0): ?>
    <?php $__currentLoopData = $after_counter; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cusCounter): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <?php if(isset($homecusSec[$cusCounter->id])): ?>
        <?php if($homecusSec[$cusCounter->id] == 1): ?>
          <?php
            $cusCounterContent = App\Models\HomePage\CustomSectionContent::where('custom_section_id', $cusCounter->id)
                ->where('language_id', $currentLanguageInfo->id)
                ->first();
          ?>
          <?php echo $__env->make('frontend.home.custom-section', ['data' => $cusCounterContent], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>
      <?php endif; ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
  <?php endif; ?>

  <!-- Testimonial-area start -->
  <?php if($secInfo->testimonial_section_status == 1): ?>
    <section class="testimonial-area testimonial-area_v1 ptb-100" data-aos="fade-up">
      <div class="container">
        <div class="wrapper">
          <div class="row">
            <div class="col-lg-12">
              <div class="section-title title-center mb-50">
                <h2 class="title fw-normal">
                  <?php echo e(!empty($sectionContent->testimonial_section_title) ? $sectionContent->testimonial_section_title : ''); ?>

                </h2>
              </div>
            </div>
            <div class="col-lg-12">
              <div class="row justify-content-center">
                <div class="col-lg-6">
                  <div class="swiper" id="testimonial-slider-1">
                    <div class="swiper-wrapper">
                      <?php $__currentLoopData = $testimonials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $testimonial): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="swiper-slide">
                          <div class="slider-item text-center">
                            <div class="client-img mb-25 mx-auto">
                              <div class="lazy-container ratio ratio-1-1">
                                <img class="lazyload"
                                  data-src="<?php echo e(asset('assets/img/clients/' . $testimonial->image)); ?>"
                                  alt="Person Image">
                              </div>
                            </div>
                            <div class="quote mb-20">
                              <p class="text">
                                <?php echo e($testimonial->comment); ?>

                              </p>
                            </div>
                            <div class="client-info">
                              <h6 class="name"><?php echo e($testimonial->name); ?></h6>
                              <span class="designation"><?php echo e($testimonial->occupation); ?></span>
                            </div>
                          </div>
                        </div>
                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    <div class="swiper-pagination position-static mt-30" id="testimonial-slider-1-pagination"></div>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div class="avatar">
            <?php $__currentLoopData = $testimonials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $testimonial): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <img class="lazyload avatar-1" data-src="<?php echo e(asset('assets/img/clients/' . $testimonial->image)); ?>"
                alt="Person Image">
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </div>
        </div>
      </div>
      <!-- Bg shape -->
      <div class="bg-shape">
        <span></span>
        <span></span>
        <span></span>
        <span></span>
      </div>
    </section>
  <?php endif; ?>
  <!-- Testimonial-area end -->

  <?php if(count($after_testimonial) > 0): ?>
    <?php $__currentLoopData = $after_testimonial; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cusTestimonial): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <?php if(isset($homecusSec[$cusTestimonial->id])): ?>
        <?php if($homecusSec[$cusTestimonial->id] == 1): ?>
          <?php
            $cusTestimonialContent = App\Models\HomePage\CustomSectionContent::where(
                'custom_section_id',
                $cusTestimonial->id,
            )
                ->where('language_id', $currentLanguageInfo->id)
                ->first();
          ?>
          <?php echo $__env->make('frontend.home.custom-section', ['data' => $cusTestimonialContent], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>
      <?php endif; ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
  <?php endif; ?>

  <!-- Blog-area start -->
  <?php if($secInfo->blog_section_status == 1): ?>
    <section class="blog-area blog-area_v1 pb-100" data-aos="fade-up">
      <div class="container">
        <div class="section-title title-inline mb-20" data-aos="fade-up">
          <h2 class="title fw-normal">
            <?php echo e(!empty($sectionContent->blog_section_title) ? $sectionContent->blog_section_title : __('Read Our Latest Blog')); ?>

          </h2>

          <?php if(count($blog_count) > count($blogs)): ?>
            <a href="<?php echo e(route('blog')); ?>" class="btn btn-lg btn-primary radius-sm"
              title="<?php echo e($sectionContent ? $sectionContent->blog_section_button_text : __('Read All Post')); ?>"
              target="_self">
              <?php echo e($sectionContent ? $sectionContent->blog_section_button_text : __('Read All Post')); ?>

            </a>
          <?php endif; ?>

        </div>
        <div class="row">
          <?php if(count($blogs) < 1): ?>
            <div class="p-3 text-center bg-light radius-md">
              <h6 class="mb-0"><?php echo e(__('NO POST FOUND')); ?></h6>
            </div>
          <?php else: ?>
            <?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <div class="col-md-6 col-xl-4" data-aos="fade-up">
                <article class="card border radius-md mt-30">
                  <div class="card_top mb-30">
                    <div class="card_img">
                      <a href="<?php echo e(route('blog_details', ['slug' => $blog->slug, 'id' => $blog->id])); ?>" target="_self"
                        title="<?php echo e(__('Link')); ?>" class="lazy-container radius-sm ratio ratio-2-3">
                        <img class="lazyload" data-src="<?php echo e(asset('assets/img/blogs/' . $blog->image)); ?>"
                          alt="Blog Image">
                      </a>
                    </div>
                  </div>
                  <div class="card_content px-20">
                    <h4 class="card_title fw-normal lc-2 mb-15">
                      <a href="<?php echo e(route('blog_details', ['slug' => $blog->slug, 'id' => $blog->id])); ?>" target="_self"
                        title="<?php echo e(__('Link')); ?>">
                        <?php echo e($blog->title); ?>

                      </a>
                    </h4>
                    <p class="card_text lc-2">
                      <?php echo e(strlen(strip_tags(convertUtf8($blog->content))) > 100 ? substr(strip_tags(convertUtf8($blog->content)), 0, 100) . '...' : strip_tags(convertUtf8($blog->content))); ?>

                    </p>
                    <div class="cta-btn mt-20">
                      <a href="<?php echo e(route('blog_details', ['slug' => $blog->slug, 'id' => $blog->id])); ?>"
                        class="btn btn-lg btn-secondary radius-sm shadow-md icon-end" title="<?php echo e($blog->title); ?>"
                        target="_self">
                        <span><?php echo e(__('Read More')); ?></span>
                        <i
                          class="fal <?php echo e($currentLanguageInfo->direction == 1 ? 'fa-long-arrow-left' : 'fa-long-arrow-right'); ?>"></i>
                      </a>
                    </div>
                  </div>
                </article>
              </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          <?php endif; ?>
        </div>
      </div>
    </section>
  <?php endif; ?>
  <!-- Blog-area end -->

  <?php if(count($after_blog) > 0): ?>
    <?php $__currentLoopData = $after_blog; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cusBlog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <?php if(isset($homecusSec[$cusBlog->id])): ?>
        <?php if($homecusSec[$cusBlog->id] == 1): ?>
          <?php
            $cusBlogContent = App\Models\HomePage\CustomSectionContent::where('custom_section_id', $cusBlog->id)
                ->where('language_id', $currentLanguageInfo->id)
                ->first();
          ?>
          <?php echo $__env->make('frontend.home.custom-section', ['data' => $cusBlogContent], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>
      <?php endif; ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
  <?php endif; ?>

  <!-- Call to action section start -->
  <?php if($secInfo->call_to_action_section_status == 1): ?>
    <section class="newsletter-area newsletter-area_v1 pb-100" data-aos="fade-up">
      <div class="container">
        <div class="newsletter-inner position-relative overflow-hidden z-1 px-3 ptb-70 radius-md bg-img"
          data-bg-img="<?php echo e(asset('assets/img/homepage/' . $images->call_to_action_section_image)); ?>">
          <div class="overlay opacity-60"></div>
          <div class="row justify-content-center">
            <div class="col-lg-6">
              <div class="content-title text-center">
                <h2 class="title mb-30 fw-normal color-white">
                  <?php echo e($sectionContent ? $sectionContent->call_to_action_section_title : ''); ?>

                </h2>
                <?php if($sectionContent && $sectionContent->call_to_action_button_url && $sectionContent->call_to_action_section_btn): ?>
                  <a href="<?php echo e($sectionContent->call_to_action_button_url); ?>" class="btn btn-lg btn-primary radius-sm"
                    title="<?php echo e($sectionContent->call_to_action_section_btn); ?>"
                    target="_self"><?php echo e($sectionContent->call_to_action_section_btn); ?></a>
                <?php endif; ?>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  <?php endif; ?>
  <!-- Call to action section-area end -->
  <?php if(count($after_call_to_action) > 0): ?>
    <?php $__currentLoopData = $after_call_to_action; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cusAction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <?php if(isset($homecusSec[$cusAction->id])): ?>
        <?php if($homecusSec[$cusAction->id] == 1): ?>
          <?php
            $cusActionContent = App\Models\HomePage\CustomSectionContent::where('custom_section_id', $cusAction->id)
                ->where('language_id', $currentLanguageInfo->id)
                ->first();
          ?>
          <?php echo $__env->make('frontend.home.custom-section', ['data' => $cusActionContent], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>
      <?php endif; ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
  <?php endif; ?>

  <!-- Modal -->
  <?php echo $__env->make('frontend.partials.map-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
  <?php if($basicInfo->google_map_api_key_status == 1): ?>
    <script src="<?php echo e(asset('assets/front/js/map-init.js')); ?>"></script>
    <script
      src="https://maps.googleapis.com/maps/api/js?key=<?php echo e($basicInfo->google_map_api_key); ?>&libraries=places&callback=initMap"
      async defer></script>
  <?php endif; ?>
  <script src="<?php echo e(asset('assets/front/js/search-home.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/samiulalimpratik/Sites/timestay/timestay/resources/views/frontend/home/index-v1.blade.php ENDPATH**/ ?>