<div class="sidebar sidebar-style-2"
  data-background-color="<?php echo e($settings->admin_theme_version == 'light' ? 'white' : 'dark2'); ?>">
  <div class="sidebar-wrapper scrollbar scrollbar-inner">
    <div class="sidebar-content">
      <div class="user">
        <div class="avatar-sm float-left mr-2">
          <?php if(Auth::guard('admin')->user()->image != null): ?>
            <img src="<?php echo e(asset('assets/img/admins/' . Auth::guard('admin')->user()->image)); ?>" alt="Admin Image"
              class="avatar-img rounded-circle">
          <?php else: ?>
            <img src="<?php echo e(asset('assets/img/blank_user.jpg')); ?>" alt="" class="avatar-img rounded-circle">
          <?php endif; ?>
        </div>

        <div class="info">
          <a data-toggle="collapse" href="#adminProfileMenu" aria-expanded="true">
            <span>
              <?php echo e(Auth::guard('admin')->user()->first_name); ?>


              <?php if(is_null($roleInfo)): ?>
                <span class="user-level"><?php echo e(__('Super Admin')); ?></span>
              <?php else: ?>
                <span class="user-level"><?php echo e($roleInfo->name); ?></span>
              <?php endif; ?>

              <span class="caret"></span>
            </span>
          </a>

          <div class="clearfix"></div>

          <div class="collapse in" id="adminProfileMenu">
            <ul class="nav">
              <li>
                <a href="<?php echo e(route('admin.edit_profile')); ?>">
                  <span class="link-collapse"><?php echo e(__('Edit Profile')); ?></span>
                </a>
              </li>

              <li>
                <a href="<?php echo e(route('admin.change_password')); ?>">
                  <span class="link-collapse"><?php echo e(__('Change Password')); ?></span>
                </a>
              </li>

              <li>
                <a href="<?php echo e(route('admin.logout')); ?>">
                  <span class="link-collapse"><?php echo e(__('Logout')); ?></span>
                </a>
              </li>
            </ul>
          </div>
        </div>
      </div>

      <?php
        if (!is_null($roleInfo)) {
            $rolePermissions = json_decode($roleInfo->permissions);
        }
      ?>

      <ul class="nav nav-primary">
        
        <div class="row mb-3">
          <div class="col-12">
            <form action="">
              <div class="form-group py-0">
                <input name="term" type="text"
                  class="form-control sidebar-search <?php echo e($defaultLang->direction == 1 ? 'rtr' : 'ltl'); ?>"
                  placeholder="<?php echo e(__('Search Menu Here...')); ?>">
              </div>
              <input type="hidden" name="language" value="<?php echo e(request()->language); ?>">

            </form>
          </div>
        </div>
        
        <li class="nav-item <?php if(request()->routeIs('admin.dashboard')): ?> active <?php endif; ?>">
          <a href="<?php echo e(route('admin.dashboard', ['language' => $defaultLang->code])); ?>">
            <i class="la flaticon-paint-palette"></i>
            <p><?php echo e(__('Dashboard')); ?></p>
          </a>
        </li>
        
        <?php if(is_null($roleInfo) || (!empty($rolePermissions) && in_array('Hotels Management', $rolePermissions))): ?>
          <li class="nav-item <?php if(request()->routeIs([
                  'admin.hotel_management.hotels',
                  'admin.hotel_management.create_hotel',
                  'admin.hotel_management.hotel.holiday',
                  'admin.hotel_management.edit_hotel',
                  'admin.hotel_management.categories',
                  'admin.hotel_management.settings',
                  'admin.hotel_management.select_vendor',
                  'admin.hotel_management.manage_counter_section',
                  'admin.hotel_management.amenities',
                  'admin.hotel_management.featured_hotel.charge',
                  'admin.hotel_management.featured_hotel.all_request',
                  'admin.hotel_management.featured_hotel.pending_request',
                  'admin.hotel_management.featured_hotel.approved_request',
                  'admin.hotel_management.featured_hotel.rejected_request',
                  'admin.hotel_management.location.countries',
                  'admin.hotel_management.location.city',
                  'admin.hotel_management.location.states',
              ])): ?> active <?php endif; ?>">
            <a data-toggle="collapse" href="#hotelManagement">
              <i class="fas fa-building"></i>
              <p><?php echo e(__('Hotels Management')); ?></p>
              <span class="caret"></span>
            </a>

            <div id="hotelManagement" class="collapse 
             <?php if(request()->routeIs([
                     'admin.hotel_management.hotels',
                     'admin.hotel_management.create_hotel',
                     'admin.hotel_management.hotel.holiday',
                     'admin.hotel_management.edit_hotel',
                     'admin.hotel_management.categories',
                     'admin.hotel_management.settings',
                     'admin.hotel_management.amenities',
                     'admin.hotel_management.select_vendor',
                     'admin.hotel_management.manage_counter_section',
                     'admin.hotel_management.featured_hotel.charge',
                     'admin.hotel_management.featured_hotel.all_request',
                     'admin.hotel_management.featured_hotel.pending_request',
                     'admin.hotel_management.featured_hotel.approved_request',
                     'admin.hotel_management.featured_hotel.rejected_request',
                     'admin.hotel_management.location.countries',
                     'admin.hotel_management.location.city',
                     'admin.hotel_management.location.states',
                 ])): ?> show <?php endif; ?>">
              <ul class="nav nav-collapse">

                <li class="<?php echo e(request()->routeIs('admin.hotel_management.settings') ? 'active' : ''); ?>">
                  <a href="<?php echo e(route('admin.hotel_management.settings', ['language' => $defaultLang->code])); ?>">
                    <span class="sub-item"><?php echo e(__('Settings')); ?></span>
                  </a>
                </li>

                <li class="submenu">
                  <a data-toggle="collapse"
                    href="#specifications"aria-expanded="<?php echo e(request()->routeIs('admin.hotel_management.location.countries') ||
                    request()->routeIs('admin.hotel_management.location.city') ||
                    request()->routeIs('admin.hotel_management.categories') ||
                    request()->routeIs('admin.hotel_management.amenities') ||
                    request()->routeIs('admin.hotel_management.location.states')
                        ? 'true'
                        : 'false'); ?>">
                    <span class="sub-item"><?php echo e(__('Specifications')); ?></span>
                    <span class="caret"></span>
                  </a>

                  <div id="specifications"
                    class="collapse 
                    <?php if(request()->routeIs('admin.hotel_management.location.countries')): ?> show 
                    <?php elseif(request()->routeIs('admin.hotel_management.location.city')): ?> show
                    <?php elseif(request()->routeIs('admin.hotel_management.categories')): ?> show
                    <?php elseif(request()->routeIs('admin.hotel_management.amenities')): ?> show
                    <?php elseif(request()->routeIs('admin.hotel_management.location.states')): ?> show <?php endif; ?>">
                    <ul class="nav nav-collapse subnav">
                      <li class="<?php echo e(request()->routeIs('admin.hotel_management.categories') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.hotel_management.categories', ['language' => $defaultLang->code])); ?>">
                          <span class="sub-item"><?php echo e(__('Categories')); ?></span>
                        </a>
                      </li>

                      <li class="<?php echo e(request()->routeIs('admin.hotel_management.amenities') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.hotel_management.amenities', ['language' => $defaultLang->code])); ?>">
                          <span class="sub-item"><?php echo e(__('Amenities')); ?></span>
                        </a>
                      </li>

                      <li class="submenu">
                        <a data-toggle="collapse"
                          href="#set-location"aria-expanded="<?php echo e(request()->routeIs('admin.hotel_management.location.countries') || request()->routeIs('admin.hotel_management.location.city') || request()->routeIs('admin.hotel_management.location.states') ? 'true' : 'false'); ?>">
                          <span class="sub-item"><?php echo e(__('Location')); ?></span>
                          <span class="caret"></span>
                        </a>
                        <div id="set-location"
                          class="collapse 
                    <?php if(request()->routeIs('admin.hotel_management.location.countries')): ?> show 
                    <?php elseif(request()->routeIs('admin.hotel_management.location.city')): ?> show
                    <?php elseif(request()->routeIs('admin.hotel_management.location.states')): ?> show <?php endif; ?>">
                          <ul class="nav nav-collapse subnav">
                            <li
                              class="<?php echo e(request()->routeIs('admin.hotel_management.location.countries') ? 'active' : ''); ?>">
                              <a
                                href="<?php echo e(route('admin.hotel_management.location.countries', ['language' => $defaultLang->code])); ?>">
                                <span class="sub-item"><?php echo e(__('Countries')); ?></span>
                              </a>
                            </li>
                            <li
                              class="<?php echo e(request()->routeIs('admin.hotel_management.location.states') ? 'active' : ''); ?>">
                              <a
                                href="<?php echo e(route('admin.hotel_management.location.states', ['language' => $defaultLang->code])); ?>">
                                <span class="sub-item"><?php echo e(__('States')); ?></span>
                              </a>
                            </li>
                            <li
                              class="<?php echo e(request()->routeIs('admin.hotel_management.location.city') ? 'active' : ''); ?>">
                              <a
                                href="<?php echo e(route('admin.hotel_management.location.city', ['language' => $defaultLang->code])); ?>">
                                <span class="sub-item"><?php echo e(__('Cities')); ?></span>
                              </a>
                            </li>
                          </ul>
                        </div>
                      </li>
                    </ul>
                  </div>
                </li>

                <li class="submenu">
                  <a data-toggle="collapse"
                    href="#manage-hotels"aria-expanded="<?php echo e(request()->routeIs('admin.hotel_management.hotels') ||
                    request()->routeIs('admin.hotel_management.select_vendor') ||
                    request()->routeIs('admin.hotel_management.edit_hotel') ||
                    request()->routeIs('admin.hotel_management.manage_counter_section') ||
                    request()->routeIs('admin.hotel_management.create_hotel')
                        ? 'true'
                        : 'false'); ?>">
                    <span class="sub-item"><?php echo e(__('Manage Hotels')); ?></span>
                    <span class="caret"></span>
                  </a>

                  <div id="manage-hotels"
                    class="collapse 
                    <?php if(request()->routeIs('admin.hotel_management.hotels')): ?> show 
                    <?php elseif(request()->routeIs('admin.hotel_management.select_vendor')): ?> show
                    <?php elseif(request()->routeIs('admin.hotel_management.edit_hotel')): ?> show
                    <?php elseif(request()->routeIs('admin.hotel_management.manage_counter_section')): ?> show
                    <?php elseif(request()->routeIs('admin.hotel_management.create_hotel')): ?> show <?php endif; ?>">
                    <ul class="nav nav-collapse subnav">
                      <li
                        class=" <?php if(request()->routeIs('admin.hotel_management.select_vendor')): ?> active
                   <?php elseif(request()->routeIs('admin.hotel_management.create_hotel')): ?> active <?php endif; ?>">
                        <a
                          href="<?php echo e(route('admin.hotel_management.select_vendor', ['language' => $defaultLang->code])); ?>">
                          <span class="sub-item"><?php echo e(__('Add Hotel')); ?></span>
                        </a>
                      </li>
                      <li
                        class=" <?php if(request()->routeIs('admin.hotel_management.hotels')): ?> active
                   <?php elseif(request()->routeIs('admin.hotel_management.edit_hotel')): ?> active 
                   <?php elseif(request()->routeIs('admin.hotel_management.manage_counter_section')): ?> active <?php endif; ?>">
                        <a href="<?php echo e(route('admin.hotel_management.hotels', ['language' => $defaultLang->code])); ?>">
                          <span class="sub-item"><?php echo e(__('Manage Hotels')); ?></span>
                        </a>
                      </li>
                    </ul>
                  </div>
                </li>

                
                <li class="submenu">
                  <a data-toggle="collapse" href="#featured-hotel"
                    aria-expanded="<?php echo e(request()->routeIs([
                        'admin.hotel_management.featured_hotel.charge',
                        'admin.hotel_management.featured_hotel.all_request',
                        'admin.hotel_management.featured_hotel.pending_request',
                        'admin.hotel_management.featured_hotel.approved_request',
                        'admin.hotel_management.featured_hotel.rejected_request',
                    ])
                        ? 'true'
                        : 'false'); ?>">
                    <span class="sub-item"><?php echo e(__('Featured Hotels')); ?></span>
                    <span class="caret"></span>
                  </a>
                  <div id="featured-hotel"
                    class="collapse <?php echo e(request()->routeIs([
                        'admin.hotel_management.featured_hotel.charge',
                        'admin.hotel_management.featured_hotel.all_request',
                        'admin.hotel_management.featured_hotel.pending_request',
                        'admin.hotel_management.featured_hotel.approved_request',
                        'admin.hotel_management.featured_hotel.rejected_request',
                    ])
                        ? 'show'
                        : ''); ?>">
                    <ul class="nav nav-collapse subnav">
                      <li
                        class="<?php echo e(request()->routeIs('admin.hotel_management.featured_hotel.charge') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.hotel_management.featured_hotel.charge')); ?>">
                          <span class="sub-item"><?php echo e(__('Charges')); ?></span>
                        </a>
                      </li>

                      <li class="submenu">
                        <a data-toggle="collapse"
                          href="#requests"aria-expanded="<?php echo e(request()->routeIs('admin.hotel_management.featured_hotel.approved_request') ||
                          request()->routeIs('admin.hotel_management.featured_hotel.pending_request') ||
                          request()->routeIs('admin.hotel_management.featured_hotel.rejected_request') ||
                          request()->routeIs('admin.hotel_management.featured_hotel.all_request')
                              ? 'true'
                              : 'false'); ?>">
                          <span class="sub-item"><?php echo e(__('Requests')); ?></span>
                          <span class="caret"></span>
                        </a>
                        <div id="requests"
                          class="collapse 
                    <?php if(request()->routeIs('admin.hotel_management.featured_hotel.approved_request')): ?> show 
                    <?php elseif(request()->routeIs('admin.hotel_management.featured_hotel.pending_request')): ?> show
                    <?php elseif(request()->routeIs('admin.hotel_management.featured_hotel.rejected_request')): ?> show
                    <?php elseif(request()->routeIs('admin.hotel_management.featured_hotel.all_request')): ?> show <?php endif; ?>">
                          <ul class="nav nav-collapse subnav">
                            <li
                              class="<?php echo e(request()->routeIs('admin.hotel_management.featured_hotel.all_request') ? 'active' : ''); ?>">
                              <a
                                href="<?php echo e(route('admin.hotel_management.featured_hotel.all_request', ['language' => $defaultLang->code])); ?>">
                                <span class="sub-item"><?php echo e(__('All')); ?></span>
                              </a>
                            </li>
                            <li
                              class="<?php echo e(request()->routeIs('admin.hotel_management.featured_hotel.pending_request') ? 'active' : ''); ?>">
                              <a
                                href="<?php echo e(route('admin.hotel_management.featured_hotel.pending_request', ['language' => $defaultLang->code])); ?>">
                                <span class="sub-item"><?php echo e(__('Pending')); ?></span>
                              </a>
                            </li>
                            <li
                              class="<?php echo e(request()->routeIs('admin.hotel_management.featured_hotel.approved_request') ? 'active' : ''); ?>">
                              <a
                                href="<?php echo e(route('admin.hotel_management.featured_hotel.approved_request', ['language' => $defaultLang->code])); ?>">
                                <span class="sub-item"><?php echo e(__('Approved')); ?></span>
                              </a>
                            </li>
                            <li
                              class="<?php echo e(request()->routeIs('admin.hotel_management.featured_hotel.rejected_request') ? 'active' : ''); ?>">
                              <a
                                href="<?php echo e(route('admin.hotel_management.featured_hotel.rejected_request', ['language' => $defaultLang->code])); ?>">
                                <span class="sub-item"><?php echo e(__('Rejected')); ?></span>
                              </a>
                            </li>
                          </ul>
                        </div>
                      </li>

                    </ul>
                  </div>
                </li>

                <li class=" <?php if(request()->routeIs('admin.hotel_management.hotel.holiday')): ?> active <?php endif; ?>">
                  <a
                    href="<?php echo e(route('admin.hotel_management.hotel.holiday', ['language' => $defaultLang->code, 'vendor_id' => 'admin'])); ?>">
                    <span class="sub-item"><?php echo e(__('Holiday')); ?></span>
                  </a>
                </li>
              </ul>
            </div>
          </li>
        <?php endif; ?>
        

        
        <?php if(is_null($roleInfo) || (!empty($rolePermissions) && in_array('Rooms Management', $rolePermissions))): ?>
          <li
            class="nav-item
        <?php echo e(request()->routeIs([
            'admin.room_management.rooms',
            'admin.room_management.create_room',
            'admin.room_management.coupons',
            'admin.room_management.featured_room.charge',
            'admin.room_management.manage_additional_service',
            'admin.room_management.select_vendor',
            'admin.room_management.settings',
            'admin.room_management.categories',
            'admin.room_management.edit_room',
            'admin.room_management.featured_room.all_request',
            'admin.room_management.featured_room.pending_request',
            'admin.room_management.featured_room.approved_request',
            'admin.room_management.featured_room.rejected_request',
            'admin.room_management.additional_services',
            'admin.room_management.tax_amount',
            'admin.room_management.booking_hours',
        ])
            ? 'active'
            : ''); ?>">
            <a data-toggle="collapse" href="#roomManagement">
              <i class="fas fa-bed"></i>
              <p><?php echo e(__('Rooms Management')); ?></p>
              <span class="caret"></span>
            </a>
            <div id="roomManagement"
              class="collapse
            <?php echo e(request()->routeIs([
                'admin.room_management.rooms',
                'admin.room_management.create_room',
                'admin.room_management.featured_room.charge',
                'admin.room_management.manage_additional_service',
                'admin.room_management.select_vendor',
                'admin.room_management.categories',
                'admin.room_management.settings',
                'admin.room_management.edit_room',
                'admin.room_management.coupons',
                'admin.room_management.featured_room.all_request',
                'admin.room_management.featured_room.pending_request',
                'admin.room_management.featured_room.approved_request',
                'admin.room_management.featured_room.rejected_request',
                'admin.room_management.additional_services',
                'admin.room_management.booking_hours',
                'admin.room_management.tax_amount',
            ])
                ? 'show'
                : ''); ?>">
              <ul class="nav nav-collapse">

                <li class="submenu">
                  <a data-toggle="collapse"
                    href="#settings-room"aria-expanded="<?php echo e(request()->routeIs('admin.room_management.settings') ||
                    request()->routeIs('admin.room_management.tax_amount') ||
                    request()->routeIs('admin.room_management.coupons')
                        ? 'true'
                        : 'false'); ?>">
                    <span class="sub-item"><?php echo e(__('Settings')); ?></span>
                    <span class="caret"></span>
                  </a>

                  <div id="settings-room"
                    class="collapse 
                    <?php if(request()->routeIs('admin.room_management.settings')): ?> show 
                    <?php elseif(request()->routeIs('admin.room_management.tax_amount')): ?> show
                    <?php elseif(request()->routeIs('admin.room_management.coupons')): ?> show <?php endif; ?>">
                    <ul class="nav nav-collapse subnav">

                      <li class="<?php echo e(request()->routeIs('admin.room_management.coupons') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.room_management.coupons', ['language' => $defaultLang->code])); ?>">
                          <span class="sub-item"><?php echo e(__('Coupons')); ?></span>
                        </a>
                      </li>

                      <li class="<?php echo e(request()->routeIs('admin.room_management.tax_amount') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.room_management.tax_amount', ['language' => $defaultLang->code])); ?>">
                          <span class="sub-item"><?php echo e(__('Tax Amount')); ?></span>
                        </a>
                      </li>
                      <li class="<?php echo e(request()->routeIs('admin.room_management.settings') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.room_management.settings', ['language' => $defaultLang->code])); ?>">
                          <span class="sub-item"><?php echo e(__('View')); ?></span>
                        </a>
                      </li>
                    </ul>
                  </div>
                </li>

                <li class="submenu">
                  <a data-toggle="collapse"
                    href="#specifications-room"aria-expanded="<?php echo e(request()->routeIs('admin.room_management.booking_hours') ||
                    request()->routeIs('admin.room_management.additional_services') ||
                    request()->routeIs('admin.room_management.categories')
                        ? 'true'
                        : 'false'); ?>">
                    <span class="sub-item"><?php echo e(__('Specifications')); ?></span>
                    <span class="caret"></span>
                  </a>

                  <div id="specifications-room"
                    class="collapse 
                    <?php if(request()->routeIs('admin.room_management.booking_hours')): ?> show 
                    <?php elseif(request()->routeIs('admin.room_management.additional_services')): ?> show
                    <?php elseif(request()->routeIs('admin.room_management.categories')): ?> show <?php endif; ?>">
                    <ul class="nav nav-collapse subnav">
                      <li class="<?php echo e(request()->routeIs('admin.room_management.categories') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.room_management.categories', ['language' => $defaultLang->code])); ?>">
                          <span class="sub-item"><?php echo e(__('Categories')); ?></span>
                        </a>
                      </li>
                      <li
                        class="<?php echo e(request()->routeIs('admin.room_management.additional_services') ? 'active' : ''); ?>">
                        <a
                          href="<?php echo e(route('admin.room_management.additional_services', ['language' => $defaultLang->code])); ?>">
                          <span class="sub-item"><?php echo e(__('Additional Services')); ?></span>
                        </a>
                      </li>

                      <li class="<?php echo e(request()->routeIs('admin.room_management.booking_hours') ? 'active' : ''); ?>">
                        <a
                          href="<?php echo e(route('admin.room_management.booking_hours', ['language' => $defaultLang->code])); ?>">
                          <span class="sub-item"><?php echo e(__('Booking Hours')); ?></span>
                        </a>
                      </li>
                    </ul>
                  </div>
                </li>

                <li class="submenu">
                  <a data-toggle="collapse"
                    href="#manage-rooms"aria-expanded="<?php echo e(request()->routeIs('admin.room_management.manage_additional_service') ||
                    request()->routeIs('admin.room_management.edit_room') ||
                    request()->routeIs('admin.room_management.rooms') ||
                    request()->routeIs('admin.room_management.create_room') ||
                    request()->routeIs('admin.room_management.select_vendor')
                        ? 'true'
                        : 'false'); ?>">
                    <span class="sub-item"><?php echo e(__('Manage Rooms')); ?></span>
                    <span class="caret"></span>
                  </a>
                  <div id="manage-rooms"
                    class="collapse 
                    <?php if(request()->routeIs('admin.room_management.manage_additional_service')): ?> show 
                    <?php elseif(request()->routeIs('admin.room_management.rooms')): ?> show
                    <?php elseif(request()->routeIs('admin.room_management.edit_room')): ?> show
                    <?php elseif(request()->routeIs('admin.room_management.create_room')): ?> show
                    <?php elseif(request()->routeIs('admin.room_management.select_vendor')): ?> show <?php endif; ?>">
                    <ul class="nav nav-collapse subnav">
                      <li
                        class="<?php echo e(request()->routeIs(['admin.room_management.select_vendor', 'admin.room_management.create_room']) ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.room_management.select_vendor')); ?>">
                          <span class="sub-item"><?php echo e(__('Add Room')); ?></span>
                        </a>
                      </li>

                      <li
                        class="<?php echo e(request()->routeIs(['admin.room_management.rooms', 'admin.room_management.edit_room', 'admin.room_management.manage_additional_service']) ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.room_management.rooms', ['language' => $defaultLang->code])); ?>">
                          <span class="sub-item"><?php echo e(__('Rooms')); ?></span>
                        </a>
                      </li>
                    </ul>
                  </div>
                </li>

                

                <li class="submenu">
                  <a data-toggle="collapse" href="#featured-room"
                    aria-expanded="<?php echo e(request()->routeIs([
                        'admin.room_management.featured_room.charge',
                        'admin.room_management.featured_room.all_request',
                        'admin.room_management.featured_room.pending_request',
                        'admin.room_management.featured_room.approved_request',
                        'admin.room_management.featured_room.rejected_request',
                    ])
                        ? 'true'
                        : 'false'); ?>">
                    <span class="sub-item"><?php echo e(__('Featured Rooms')); ?></span>
                    <span class="caret"></span>
                  </a>
                  <div id="featured-room"
                    class="collapse <?php echo e(request()->routeIs([
                        'admin.room_management.featured_room.charge',
                        'admin.room_management.featured_room.all_request',
                        'admin.room_management.featured_room.pending_request',
                        'admin.room_management.featured_room.approved_request',
                        'admin.room_management.featured_room.rejected_request',
                    ])
                        ? 'show'
                        : ''); ?>">
                    <ul class="nav nav-collapse subnav">
                      <li
                        class="<?php echo e(request()->routeIs('admin.room_management.featured_room.charge') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.room_management.featured_room.charge')); ?>">
                          <span class="sub-item"><?php echo e(__('Charges')); ?></span>
                        </a>
                      </li>

                      <li class="submenu">
                        <a data-toggle="collapse"
                          href="#requests"aria-expanded="<?php echo e(request()->routeIs('admin.room_management.featured_room.approved_request') ||
                          request()->routeIs('admin.room_management.featured_room.pending_request') ||
                          request()->routeIs('admin.room_management.featured_room.rejected_request') ||
                          request()->routeIs('admin.room_management.featured_room.all_request')
                              ? 'true'
                              : 'false'); ?>">
                          <span class="sub-item"><?php echo e(__('Requests')); ?></span>
                          <span class="caret"></span>
                        </a>
                        <div id="requests"
                          class="collapse 
                    <?php if(request()->routeIs('admin.room_management.featured_room.approved_request')): ?> show 
                    <?php elseif(request()->routeIs('admin.room_management.featured_room.pending_request')): ?> show
                    <?php elseif(request()->routeIs('admin.room_management.featured_room.rejected_request')): ?> show
                    <?php elseif(request()->routeIs('admin.room_management.featured_room.all_request')): ?> show <?php endif; ?>">
                          <ul class="nav nav-collapse subnav">
                            <li
                              class="<?php echo e(request()->routeIs('admin.room_management.featured_room.all_request') ? 'active' : ''); ?>">
                              <a
                                href="<?php echo e(route('admin.room_management.featured_room.all_request', ['language' => $defaultLang->code])); ?>">
                                <span class="sub-item"><?php echo e(__('All')); ?></span>
                              </a>
                            </li>
                            <li
                              class="<?php echo e(request()->routeIs('admin.room_management.featured_room.pending_request') ? 'active' : ''); ?>">
                              <a
                                href="<?php echo e(route('admin.room_management.featured_room.pending_request', ['language' => $defaultLang->code])); ?>">
                                <span class="sub-item"><?php echo e(__('Pending')); ?></span>
                              </a>
                            </li>
                            <li
                              class="<?php echo e(request()->routeIs('admin.room_management.featured_room.approved_request') ? 'active' : ''); ?>">
                              <a
                                href="<?php echo e(route('admin.room_management.featured_room.approved_request', ['language' => $defaultLang->code])); ?>">
                                <span class="sub-item"><?php echo e(__('Approved')); ?></span>
                              </a>
                            </li>
                            <li
                              class="<?php echo e(request()->routeIs('admin.room_management.featured_room.rejected_request') ? 'active' : ''); ?>">
                              <a
                                href="<?php echo e(route('admin.room_management.featured_room.rejected_request', ['language' => $defaultLang->code])); ?>">
                                <span class="sub-item"><?php echo e(__('Rejected')); ?></span>
                              </a>
                            </li>
                          </ul>
                        </div>
                      </li>

                    </ul>
                  </div>
                </li>
              </ul>
            </div>
          </li>
        <?php endif; ?>
        

        
        <?php if(is_null($roleInfo) || (!empty($rolePermissions) && in_array('Room Bookings', $rolePermissions))): ?>
          <li
            class="nav-item <?php if(request()->routeIs('admin.room_bookings.all_bookings')): ?> active
            <?php elseif(request()->routeIs('admin.room_bookings.paid_bookings')): ?> active
            <?php elseif(request()->routeIs('admin.room_bookings.unpaid_bookings')): ?> active
            <?php elseif(request()->routeIs('admin.room_bookings.report')): ?> active
            <?php elseif(request()->routeIs('admin.room_bookings.booking_details_and_edit')): ?> active
            <?php elseif(request()->routeIs('admin.room_bookings.booking_details')): ?> active
            <?php elseif(request()->routeIs('admin.room_bookings.booking_form')): ?> active <?php endif; ?>">
            <a data-toggle="collapse" href="#roomBookings">
              <i class="far fa-calendar-check"></i>
              <p class="pr-2"><?php echo e(__('Room Bookings')); ?></p>
              <span class="caret"></span>
            </a>
            <div id="roomBookings"
              class="collapse
              <?php if(request()->routeIs('admin.room_bookings.all_bookings')): ?> show
              <?php elseif(request()->routeIs('admin.room_bookings.paid_bookings')): ?> show
              <?php elseif(request()->routeIs('admin.room_bookings.unpaid_bookings')): ?> show
              <?php elseif(request()->routeIs('admin.room_bookings.report')): ?> show
              <?php elseif(request()->routeIs('admin.room_bookings.booking_details')): ?> show
              <?php elseif(request()->routeIs('admin.room_bookings.booking_details_and_edit')): ?> show
              <?php elseif(request()->routeIs('admin.room_bookings.booking_form')): ?> show <?php endif; ?>">
              <ul class="nav nav-collapse">
                <li class="<?php echo e(request()->routeIs('admin.room_bookings.all_bookings') ? 'active' : ''); ?>">
                  <a href="<?php echo e(route('admin.room_bookings.all_bookings', ['language' => $defaultLang->code])); ?>">
                    <span class="sub-item"><?php echo e(__('All Bookings')); ?></span>
                  </a>
                </li>
                <li class="<?php echo e(request()->routeIs('admin.room_bookings.paid_bookings') ? 'active' : ''); ?>">
                  <a href="<?php echo e(route('admin.room_bookings.paid_bookings', ['language' => $defaultLang->code])); ?>">
                    <span class="sub-item"><?php echo e(__('Paid Bookings')); ?></span>
                  </a>
                </li>
                <li class="<?php echo e(request()->routeIs('admin.room_bookings.unpaid_bookings') ? 'active' : ''); ?>">
                  <a href="<?php echo e(route('admin.room_bookings.unpaid_bookings', ['language' => $defaultLang->code])); ?>">
                    <span class="sub-item"><?php echo e(__('Unpaid Bookings')); ?></span>
                  </a>
                </li>
                <li class="<?php echo e(request()->routeIs('admin.room_bookings.report') ? 'active' : ''); ?>">
                  <a href="<?php echo e(route('admin.room_bookings.report')); ?>">
                    <span class="sub-item"><?php echo e(__('Report')); ?></span>
                  </a>
                </li>
              </ul>
            </div>
          </li>
        <?php endif; ?>

        
        <?php if(is_null($roleInfo) || (!empty($rolePermissions) && in_array('User Management', $rolePermissions))): ?>
          <li
            class="nav-item <?php if(request()->routeIs('admin.user_management.registered_users')): ?> active 
            <?php elseif(request()->routeIs('admin.user_management.registered_user.create')): ?> active 
            <?php elseif(request()->routeIs('admin.user_management.registered_user.view')): ?> active 
            <?php elseif(request()->routeIs('admin.user_management.registered_user.edit')): ?> active 
            <?php elseif(request()->routeIs('admin.user_management.user.change_password')): ?> active 
            <?php elseif(request()->routeIs('admin.user_management.subscribers')): ?> active 
            <?php elseif(request()->routeIs('admin.user_management.mail_for_subscribers')): ?> active 
            <?php elseif(request()->routeIs('admin.user_management.push_notification.settings')): ?> active 
            <?php elseif(request()->routeIs('admin.user_management.push_notification.notification_for_visitors')): ?> active <?php endif; ?>">
            <a data-toggle="collapse" href="#user">
              <i class="la flaticon-users"></i>
              <p><?php echo e(__('Users Management')); ?></p>
              <span class="caret"></span>
            </a>

            <div id="user"
              class="collapse 
              <?php if(request()->routeIs('admin.user_management.registered_users')): ?> show 
              <?php elseif(request()->routeIs('admin.user_management.registered_user.create')): ?> show 
              <?php elseif(request()->routeIs('admin.user_management.registered_user.view')): ?> show 
              <?php elseif(request()->routeIs('admin.user_management.registered_user.edit')): ?> show 
              <?php elseif(request()->routeIs('admin.user_management.user.change_password')): ?> show 
              <?php elseif(request()->routeIs('admin.user_management.subscribers')): ?> show 
              <?php elseif(request()->routeIs('admin.user_management.mail_for_subscribers')): ?> show 
              <?php elseif(request()->routeIs('admin.user_management.push_notification.settings')): ?> show 
              <?php elseif(request()->routeIs('admin.user_management.push_notification.notification_for_visitors')): ?> show <?php endif; ?>">
              <ul class="nav nav-collapse">
                <li
                  class="<?php if(request()->routeIs('admin.user_management.registered_users')): ?> active 
                  <?php elseif(request()->routeIs('admin.user_management.user.change_password')): ?> active
                  <?php elseif(request()->routeIs('admin.user_management.registered_user.view')): ?> active
                  <?php elseif(request()->routeIs('admin.user_management.registered_user.edit')): ?>
                  active <?php endif; ?>
                  ">
                  <a
                    href="<?php echo e(route('admin.user_management.registered_users', ['language' => $defaultLang->code])); ?>">
                    <span class="sub-item"><?php echo e(__('Registered Users')); ?></span>
                  </a>
                </li>

                <li class="<?php if(request()->routeIs('admin.user_management.registered_user.create')): ?> active <?php endif; ?>
                  ">
                  <a
                    href="<?php echo e(route('admin.user_management.registered_user.create', ['language' => $defaultLang->code])); ?>">
                    <span class="sub-item"><?php echo e(__('Add User')); ?></span>
                  </a>
                </li>

                <li
                  class="<?php if(request()->routeIs('admin.user_management.subscribers')): ?> active 
                  <?php elseif(request()->routeIs('admin.user_management.mail_for_subscribers')): ?> active <?php endif; ?>">
                  <a href="<?php echo e(route('admin.user_management.subscribers', ['language' => $defaultLang->code])); ?>">
                    <span class="sub-item"><?php echo e(__('Subscribers')); ?></span>
                  </a>
                </li>

                <li class="submenu">
                  <a data-toggle="collapse" href="#push_notification">
                    <span class="sub-item"><?php echo e(__('Push Notification')); ?></span>
                    <span class="caret"></span>
                  </a>

                  <div id="push_notification"
                    class="collapse 
                    <?php if(request()->routeIs('admin.user_management.push_notification.settings')): ?> show 
                    <?php elseif(request()->routeIs('admin.user_management.push_notification.notification_for_visitors')): ?> show <?php endif; ?>">
                    <ul class="nav nav-collapse subnav">
                      <li
                        class="<?php echo e(request()->routeIs('admin.user_management.push_notification.settings') ? 'active' : ''); ?>">
                        <a
                          href="<?php echo e(route('admin.user_management.push_notification.settings', ['language' => $defaultLang->code])); ?>">
                          <span class="sub-item"><?php echo e(__('Settings')); ?></span>
                        </a>
                      </li>

                      <li
                        class="<?php echo e(request()->routeIs('admin.user_management.push_notification.notification_for_visitors') ? 'active' : ''); ?>">
                        <a
                          href="<?php echo e(route('admin.user_management.push_notification.notification_for_visitors', ['language' => $defaultLang->code])); ?>">
                          <span class="sub-item"><?php echo e(__('Send Notification')); ?></span>
                        </a>
                      </li>
                    </ul>
                  </div>
                </li>
              </ul>
            </div>
          </li>
        <?php endif; ?>

        
        <?php if(is_null($roleInfo) || (!empty($rolePermissions) && in_array('Vendors Management', $rolePermissions))): ?>
          <li
            class="nav-item <?php if(request()->routeIs('admin.vendor_management.registered_vendor')): ?> active
            <?php elseif(request()->routeIs('admin.vendor_management.add_vendor')): ?> active
            <?php elseif(request()->routeIs('admin.vendor_management.vendor_details')): ?> active
            <?php elseif(request()->routeIs('admin.edit_management.vendor_edit')): ?> active
            <?php elseif(request()->routeIs('admin.vendor_management.settings')): ?> active
            <?php elseif(request()->routeIs('admin.vendor_management.vendor.change_password')): ?> active <?php endif; ?>">
            <a data-toggle="collapse" href="#vendor">
              <i class="la flaticon-users"></i>
              <p><?php echo e(__('Vendors Management')); ?></p>
              <span class="caret"></span>
            </a>

            <div id="vendor"
              class="collapse
              <?php if(request()->routeIs('admin.vendor_management.registered_vendor')): ?> show
              <?php elseif(request()->routeIs('admin.vendor_management.vendor_details')): ?> show
              <?php elseif(request()->routeIs('admin.edit_management.vendor_edit')): ?> show
              <?php elseif(request()->routeIs('admin.vendor_management.add_vendor')): ?> show
              <?php elseif(request()->routeIs('admin.vendor_management.settings')): ?> show
              <?php elseif(request()->routeIs('admin.vendor_management.vendor.change_password')): ?> show <?php endif; ?>">
              <ul class="nav nav-collapse">
                <li class="<?php if(request()->routeIs('admin.vendor_management.settings')): ?> active <?php endif; ?>">
                  <a href="<?php echo e(route('admin.vendor_management.settings', ['language' => $defaultLang->code])); ?>">
                    <span class="sub-item"><?php echo e(__('Settings')); ?></span>
                  </a>
                </li>
                <li
                  class="<?php if(request()->routeIs('admin.vendor_management.registered_vendor')): ?> active
                  <?php elseif(request()->routeIs('admin.vendor_management.vendor_details')): ?> active
                  <?php elseif(request()->routeIs('admin.edit_management.vendor_edit')): ?> active
                  <?php elseif(request()->routeIs('admin.vendor_management.vendor.change_password')): ?> active <?php endif; ?>">
                  <a
                    href="<?php echo e(route('admin.vendor_management.registered_vendor', ['language' => $defaultLang->code])); ?>">
                    <span class="sub-item"><?php echo e(__('Registered vendors')); ?></span>
                  </a>
                </li>
                <li class="<?php if(request()->routeIs('admin.vendor_management.add_vendor')): ?> active <?php endif; ?>">
                  <a href="<?php echo e(route('admin.vendor_management.add_vendor', ['language' => $defaultLang->code])); ?>">
                    <span class="sub-item"><?php echo e(__('Add vendor')); ?></span>
                  </a>
                </li>
              </ul>
            </div>
          </li>
        <?php endif; ?>

        
        <?php if(is_null($roleInfo) || (!empty($rolePermissions) && in_array('Subscription Log', $rolePermissions))): ?>
          <li class="nav-item <?php if(request()->routeIs('admin.subscription-log')): ?> active <?php endif; ?>">
            <a href="<?php echo e(route('admin.subscription-log', ['language' => $defaultLang->code])); ?>">
              <i class="fas fa-list-ol"></i>
              <p><?php echo e(__('Subscription Log')); ?></p>
            </a>
          </li>
        <?php endif; ?>
        

        
        <?php if(is_null($roleInfo) || (!empty($rolePermissions) && in_array('Withdrawals Management', $rolePermissions))): ?>
          <li
            class="nav-item
          <?php if(request()->routeIs('admin.withdraw.payment_method')): ?> active
          <?php elseif(request()->routeIs('admin.withdraw.payment_method')): ?> active
          <?php elseif(request()->routeIs('admin.withdraw_payment_method.mange_input')): ?> active
          <?php elseif(request()->routeIs('admin.withdraw_payment_method.edit_input')): ?> active
          <?php elseif(request()->routeIs('admin.withdraw.withdraw_request')): ?> active <?php endif; ?>">
            <a data-toggle="collapse" href="#withdraw_method">
              <i class="fal fa-credit-card"></i>
              <p><?php echo e(__('Withdrawals Management')); ?></p>
              <span class="caret"></span>
            </a>

            <div id="withdraw_method"
              class="collapse
            <?php if(request()->routeIs('admin.withdraw.payment_method')): ?> show
            <?php elseif(request()->routeIs('admin.withdraw.payment_method')): ?> show
            <?php elseif(request()->routeIs('admin.withdraw_payment_method.mange_input')): ?> show
            <?php elseif(request()->routeIs('admin.withdraw_payment_method.edit_input')): ?> show
            <?php elseif(request()->routeIs('admin.withdraw.withdraw_request')): ?> show <?php endif; ?>">
              <ul class="nav nav-collapse">
                <li
                  class="<?php echo e(request()->routeIs('admin.withdraw.payment_method') && empty(request()->input('status')) ? 'active' : ''); ?>">
                  <a href="<?php echo e(route('admin.withdraw.payment_method', ['language' => $defaultLang->code])); ?>">
                    <span class="sub-item"><?php echo e(__('Payment Methods')); ?></span>
                  </a>
                </li>

                <li
                  class="<?php echo e(request()->routeIs('admin.withdraw.withdraw_request') && empty(request()->input('status')) ? 'active' : ''); ?>">
                  <a href="<?php echo e(route('admin.withdraw.withdraw_request', ['language' => $defaultLang->code])); ?>">
                    <span class="sub-item"><?php echo e(__('Withdraw Requests')); ?></span>
                  </a>
                </li>
              </ul>
            </div>
          </li>
        <?php endif; ?>

        
        <?php if(is_null($roleInfo) || (!empty($rolePermissions) && in_array('Packages Management', $rolePermissions))): ?>
          <li
            class="nav-item <?php if(request()->routeIs('admin.package.settings')): ?> active 
            <?php elseif(request()->routeIs('admin.package.index')): ?> active 
            <?php elseif(request()->routeIs('admin.package.edit')): ?> active <?php endif; ?>">
            <a data-toggle="collapse" href="#packageManagement">
              <i class="fal fa-receipt"></i>
              <p><?php echo e(__('Packages Management')); ?></p>
              <span class="caret"></span>
            </a>

            <div id="packageManagement"
              class="collapse 
              <?php if(request()->routeIs('admin.package.settings')): ?> show 
              <?php elseif(request()->routeIs('admin.package.index')): ?> show 
              <?php elseif(request()->routeIs('admin.package.edit')): ?> show <?php endif; ?>">
              <ul class="nav nav-collapse">

                <li class="<?php echo e(request()->routeIs('admin.package.settings') ? 'active' : ''); ?>">
                  <a href="<?php echo e(route('admin.package.settings', ['language' => $defaultLang->code])); ?>">
                    <span class="sub-item"><?php echo e(__('Settings')); ?></span>
                  </a>
                </li>
                <li
                  class=" <?php if(request()->routeIs('admin.package.index')): ?> active 
            <?php elseif(request()->routeIs('admin.package.edit')): ?> active <?php endif; ?>">
                  <a href="<?php echo e(route('admin.package.index', ['language' => $defaultLang->code])); ?>">
                    <span class="sub-item"><?php echo e(__('Packages')); ?></span>
                  </a>
                </li>

              </ul>
            </div>
          </li>
        <?php endif; ?>

        
        <?php if(is_null($roleInfo) || (!empty($rolePermissions) && in_array('Menu Builder', $rolePermissions))): ?>
          <li class="nav-item <?php if(request()->routeIs('admin.menu_builder')): ?> active <?php endif; ?>">
            <a href="<?php echo e(route('admin.menu_builder', ['language' => $defaultLang->code])); ?>">
              <i class="fal fa-bars"></i>
              <p><?php echo e(__('Menu Builder')); ?></p>
            </a>
          </li>
        <?php endif; ?>

        <?php if(is_null($roleInfo) || (!empty($rolePermissions) && in_array('Pages', $rolePermissions))): ?>
          <li class="nav-item
            <?php if(request()->routeIs([
                    'admin.pages.home_page.section_content',
                    'admin.pages.home_page.hero_section.slider_version',
                    'admin.pages.counter_section',
                    'admin.pages.about_us.counter_section',
                    'admin.pages.testimonial_section',
                    'admin.pages.home_page.product_section',
                    'admin.pages.home_page.section_customization',
                    'admin.pages.home_page.partners',
                    'admin.pages.faq_management',
                    'admin.pages.about_us.index',
                    'admin.pages.blog.categories',
                    'admin.pages.blog.blogs',
                    'admin.pages.blog.create_blog',
                    'admin.pages.blog.edit_blog',
                    'admin.pages.home_page.benifit_section',
                    'admin.pages.footer.logo_and_image',
                    'admin.pages.footer.content',
                    'admin.pages.footer.quick_links',
                    'admin.settings.seo',
                    'admin.pages.breadcrumb.image',
                    'admin.pages.breadcrumb.headings',
                    'admin.pages.additional_pages',
                    'admin.pages.additional_pages.create_page',
                    'admin.pages.feature_section',
                    'admin.pages.additional_pages.edit_page',
                    'admin.pages.about_us.customize',
                    'admin.additional_sections',
                    'admin.additional_section.create',
                    'admin.additional_section.edit',
                    'admin.pages.home_page.additional_sections',
                    'admin.pages.home_page.additional_section.create',
                    'admin.pages.home_page.additional_section.edit',
                    'admin.pages.contact_page',
                ])): ?> active <?php endif; ?>">
            <a data-toggle="collapse" href="#pages">
              <i class="la flaticon-file"></i>
              <p><?php echo e(__('Pages')); ?></p>
              <span class="caret"></span>
            </a>
            <div id="pages" class="collapse
            <?php if(request()->routeIs([
                    'admin.pages.home_page.section_content',
                    'admin.pages.home_page.hero_section.slider_version',
                    'admin.pages.counter_section',
                    'admin.pages.about_us.counter_section',
                    'admin.pages.testimonial_section',
                    'admin.pages.home_page.product_section',
                    'admin.pages.home_page.section_customization',
                    'admin.pages.home_page.partners',
                    'admin.pages.faq_management',
                    'admin.pages.feature_section',
                    'admin.pages.about_us.index',
                    'admin.pages.blog.categories',
                    'admin.pages.blog.blogs',
                    'admin.pages.blog.create_blog',
                    'admin.pages.blog.edit_blog',
                    'admin.pages.home_page.benifit_section',
                    'admin.pages.footer.logo_and_image',
                    'admin.pages.footer.content',
                    'admin.pages.footer.quick_links',
                    'admin.settings.seo',
                    'admin.pages.breadcrumb.image',
                    'admin.pages.breadcrumb.headings',
                    'admin.pages.additional_pages',
                    'admin.pages.additional_pages.create_page',
                    'admin.pages.additional_pages.edit_page',
                    'admin.pages.about_us.customize',
                    'admin.additional_sections',
                    'admin.additional_section.create',
                    'admin.additional_section.edit',
                    'admin.pages.home_page.additional_sections',
                    'admin.pages.home_page.additional_section.create',
                    'admin.pages.home_page.additional_section.edit',
                    'admin.pages.contact_page',
                ])): ?> show <?php endif; ?>">
              <ul class="nav
              nav-collapse">
                
                <li class="submenu">
                  <a data-toggle="collapse" href="#home-page"
                    aria-expanded="<?php echo e(request()->routeIs('admin.pages.home_page.section_content') ||
                    request()->routeIs('admin.pages.home_page.hero_section.slider_version') ||
                    request()->routeIs('admin.pages.counter_section') ||
                    request()->routeIs('admin.pages.home_page.product_section') ||
                    request()->routeIs('admin.pages.home_page.benifit_section') ||
                    request()->routeIs('admin.pages.home_page.additional_sections') ||
                    request()->routeIs('admin.pages.feature_section') ||
                    request()->routeIs('admin.pages.home_page.additional_section.edit') ||
                    request()->routeIs('admin.pages.home_page.additional_section.create') ||
                    request()->routeIs('admin.pages.home_page.section_customization') ||
                    request()->routeIs('admin.pages.home_page.partners')
                        ? 'true'
                        : 'false'); ?>">
                    <span class="sub-item"><?php echo e(__('Home Page')); ?></span>
                    <span class="caret"></span>
                  </a>
                  <div id="home-page"
                    class="collapse
                    <?php if(request()->routeIs('admin.pages.home_page.section_content') ||
                            request()->routeIs('admin.pages.home_page.hero_section.slider_version') ||
                            request()->routeIs('admin.pages.counter_section') ||
                            request()->routeIs('admin.pages.home_page.product_section') ||
                            request()->routeIs('admin.pages.home_page.section_customization') ||
                            request()->routeIs('admin.pages.feature_section') ||
                            request()->routeIs('admin.pages.home_page.partners') ||
                            request()->routeIs('admin.pages.home_page.benifit_section') ||
                            request()->routeIs('admin.shop_management.create_product') ||
                            request()->routeIs('admin.pages.home_page.additional_sections') ||
                            request()->routeIs('admin.pages.home_page.additional_section.edit') ||
                            request()->routeIs('admin.pages.home_page.additional_section.create') ||
                            request()->routeIs('admin.shop_management.edit_product')): ?> show <?php endif; ?>">
                    <ul class="nav nav-collapse subnav">
                      <li class="<?php echo e(request()->routeIs('admin.pages.home_page.section_content') ? 'active' : ''); ?>">
                        <a
                          href="<?php echo e(route('admin.pages.home_page.section_content', ['language' => $defaultLang->code])); ?>">
                          <span class="sub-item"><?php echo e(__('Images & Texts')); ?></span>
                        </a>
                      </li>
                      <!-- additional sections -->
                      <li class="submenu">
                        <a data-toggle="collapse" href="#home-add-section"
                          aria-expanded="<?php echo e(request()->routeIs('admin.pages.home_page.additional_sections') ||
                          request()->routeIs('admin.pages.home_page.additional_section.create') ||
                          request()->routeIs('admin.pages.home_page.additional_section.edit')
                              ? 'true'
                              : 'false'); ?>">
                          <span class="sub-item"><?php echo e(__('Additional Sections')); ?></span>
                          <span class="caret"></span>
                        </a>
                        <div id="home-add-section"
                          class="collapse
                    <?php if(request()->routeIs('admin.pages.home_page.additional_sections') ||
                            request()->routeIs('admin.pages.home_page.additional_section.create') ||
                            request()->routeIs('admin.pages.home_page.additional_section.edit')): ?> show <?php endif; ?> pl-3">
                          <ul class="nav nav-collapse subnav">
                            <li
                              class="<?php echo e(request()->routeIs('admin.pages.home_page.additional_section.create') ? 'active' : ''); ?>">
                              <a href="<?php echo e(route('admin.pages.home_page.additional_section.create')); ?>">
                                <span class="sub-item"><?php echo e(__('Add Section')); ?></span>
                              </a>
                            </li>
                            <li
                              class="<?php echo e(request()->routeIs('admin.pages.home_page.additional_sections') || request()->routeIs('admin.pages.home_page.additional_section.edit') ? 'active' : ''); ?>">
                              <a
                                href="<?php echo e(route('admin.pages.home_page.additional_sections', ['language' => $defaultLang->code])); ?>">
                                <span class="sub-item"><?php echo e(__('Sections')); ?>

                                </span>
                              </a>
                            </li>
                          </ul>
                        </div>
                      </li>

                      <?php if($settings->theme_version == 2): ?>
                        <li
                          class="<?php echo e(request()->routeIs('admin.pages.home_page.hero_section.slider_version') ? 'active' : ''); ?>">
                          <a
                            href="<?php echo e(route('admin.pages.home_page.hero_section.slider_version', ['language' => $defaultLang->code])); ?>">
                            <span class="sub-item"><?php echo e(__('Sliders')); ?></span>
                          </a>
                        </li>
                      <?php endif; ?>

                      <?php if($settings->theme_version == 3): ?>
                        <li
                          class="<?php echo e(request()->routeIs('admin.pages.home_page.benifit_section') ? 'active' : ''); ?>">
                          <a
                            href="<?php echo e(route('admin.pages.home_page.benifit_section', ['language' => $defaultLang->code])); ?>">
                            <span class="sub-item"><?php echo e(__('Benifit Section')); ?></span>
                          </a>
                        </li>
                      <?php endif; ?>

                      <li
                        class="<?php echo e(request()->routeIs('admin.pages.home_page.section_customization') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.pages.home_page.section_customization')); ?>">
                          <span class="sub-item"><?php echo e(__('Section Show/Hide')); ?></span>
                        </a>
                      </li>
                    </ul>
                  </div>
                </li>
                
                <li class="submenu">
                  <a data-toggle="collapse" href="#about-page"
                    aria-expanded="<?php echo e(request()->routeIs('admin.pages.about_us.index') ||
                    request()->routeIs('admin.pages.about_us.customize') ||
                    request()->routeIs('admin.additional_sections') ||
                    request()->routeIs('admin.pages.about_us.counter_section') ||
                    request()->routeIs('admin.additional_section.create') ||
                    request()->routeIs('admin.additional_section.edit')
                        ? 'true'
                        : 'false'); ?>">
                    <span class="sub-item"><?php echo e(__('About Us')); ?></span>
                    <span class="caret"></span>
                  </a>
                  <div id="about-page"
                    class="collapse
                    <?php if(request()->routeIs('admin.pages.about_us.index') ||
                            request()->routeIs('admin.about_us.customize') ||
                            request()->routeIs('admin.additional_sections') ||
                            request()->routeIs('admin.pages.about_us.counter_section') ||
                            request()->routeIs('admin.pages.about_us.customize') ||
                            request()->routeIs('admin.additional_section.create') ||
                            request()->routeIs('admin.additional_section.edit')): ?> show <?php endif; ?>">
                    <ul class="nav nav-collapse subnav">
                      <li class="<?php echo e(request()->routeIs('admin.pages.about_us.index') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.pages.about_us.index', ['language' => $defaultLang->code])); ?>">
                          <span class="sub-item"><?php echo e(__('About')); ?></span>
                        </a>
                      </li>

                      <!-- additional sections -->
                      <li class="submenu">
                        <a data-toggle="collapse" href="#addi-section"
                          aria-expanded="<?php echo e(request()->routeIs('admin.additional_sections') ||
                          request()->routeIs('admin.additional_section.create') ||
                          request()->routeIs('admin.additional_section.edit')
                              ? 'true'
                              : 'false'); ?>">
                          <span class="sub-item"><?php echo e(__('Additional Sections')); ?></span>
                          <span class="caret"></span>
                        </a>
                        <div id="addi-section"
                          class="collapse
                    <?php if(request()->routeIs('admin.additional_sections') ||
                            request()->routeIs('admin.additional_section.create') ||
                            request()->routeIs('admin.additional_section.edit')): ?> show <?php endif; ?> pl-3">
                          <ul class="nav nav-collapse subnav">
                            <li class="<?php echo e(request()->routeIs('admin.additional_section.create') ? 'active' : ''); ?>">
                              <a href="<?php echo e(route('admin.additional_section.create')); ?>">
                                <span class="sub-item"><?php echo e(__('Add Section')); ?></span>
                              </a>
                            </li>
                            <li
                              class="<?php echo e(request()->routeIs('admin.additional_sections') || request()->routeIs('admin.additional_section.edit') ? 'active' : ''); ?>">
                              <a href="<?php echo e(route('admin.additional_sections', ['language' => $defaultLang->code])); ?>">
                                <span class="sub-item"><?php echo e(__('Sections')); ?>

                                </span>
                              </a>
                            </li>
                          </ul>
                        </div>
                      </li>

                      <?php if($settings->theme_version == 3): ?>
                        <li class="<?php echo e(request()->routeIs('admin.pages.about_us.counter_section') ? 'active' : ''); ?>">
                          <a
                            href="<?php echo e(route('admin.pages.about_us.counter_section', ['language' => $defaultLang->code])); ?>">
                            <span class="sub-item"><?php echo e(__('Counters')); ?></span>
                          </a>
                        </li>
                      <?php endif; ?>

                      <li class="<?php echo e(request()->routeIs('admin.pages.about_us.customize') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.pages.about_us.customize', ['language' => $defaultLang->code])); ?>">
                          <span class="sub-item"><?php echo e(__('Hide / Show Section')); ?></span>
                        </a>
                      </li>
                    </ul>
                  </div>
                </li>


                <li class="submenu">
                  <a data-toggle="collapse"
                    href="#commonsections"aria-expanded="<?php echo e(request()->routeIs('admin.pages.footer.content') ||
                    request()->routeIs('admin.pages.footer.logo_and_image') ||
                    request()->routeIs('admin.pages.counter_section') ||
                    request()->routeIs('admin.pages.testimonial_section') ||
                    request()->routeIs('admin.pages.footer.quick_links') ||
                    request()->routeIs('admin.pages.breadcrumb.image') ||
                    request()->routeIs('admin.pages.breadcrumb.headings') ||
                    request()->routeIs('admin.pages.feature_section')
                        ? 'true'
                        : 'false'); ?>">
                    <span class="sub-item"><?php echo e(__('Common Sections')); ?></span>
                    <span class="caret"></span>
                  </a>

                  <div id="commonsections"
                    class="collapse 
                    <?php if(request()->routeIs('admin.pages.footer.content')): ?> show 
                    <?php elseif(request()->routeIs('admin.pages.footer.logo_and_image')): ?> show
                    <?php elseif(request()->routeIs('admin.pages.counter_section')): ?> show
                    <?php elseif(request()->routeIs('admin.pages.footer.quick_links')): ?> show
                    <?php elseif(request()->routeIs('admin.pages.breadcrumb.image')): ?> show
                    <?php elseif(request()->routeIs('admin.pages.testimonial_section')): ?> show
                    <?php elseif(request()->routeIs('admin.pages.breadcrumb.headings')): ?> show
                    <?php elseif(request()->routeIs('admin.pages.feature_section')): ?> show <?php endif; ?>">
                    <ul class="nav nav-collapse subnav">


                      <li class="<?php echo e(request()->routeIs('admin.pages.feature_section') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.pages.feature_section', ['language' => $defaultLang->code])); ?>">
                          <span class="sub-item"><?php echo e(__('Features')); ?></span>
                        </a>
                      </li>

                      <li class="<?php echo e(request()->routeIs('admin.pages.testimonial_section') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.pages.testimonial_section', ['language' => $defaultLang->code])); ?>">
                          <span class="sub-item"><?php echo e(__('Testimonials')); ?></span>
                        </a>
                      </li>
                      <?php if($settings->theme_version != 3): ?>
                        <li class="<?php echo e(request()->routeIs('admin.pages.counter_section') ? 'active' : ''); ?>">
                          <a href="<?php echo e(route('admin.pages.counter_section', ['language' => $defaultLang->code])); ?>">
                            <span class="sub-item"><?php echo e(__('Counters')); ?></span>
                          </a>
                        </li>
                      <?php endif; ?>

                      <li class="submenu">
                        <a data-toggle="collapse"
                          href="#footer-common"aria-expanded="<?php echo e(request()->routeIs('admin.pages.footer.quick_links') || request()->routeIs('admin.pages.footer.content') || request()->routeIs('admin.pages.footer.logo_and_image') ? 'true' : 'false'); ?>">
                          <span class="sub-item"><?php echo e(__('Footer')); ?></span>
                          <span class="caret"></span>
                        </a>
                        <div id="footer-common"
                          class="collapse 
                    <?php if(request()->routeIs('admin.pages.footer.quick_links')): ?> show 
                    <?php elseif(request()->routeIs('admin.pages.footer.content')): ?> show
                    <?php elseif(request()->routeIs('admin.pages.footer.logo_and_image')): ?> show <?php endif; ?>">
                          <ul class="nav nav-collapse subnav">
                            <li
                              class="<?php echo e(request()->routeIs('admin.pages.footer.logo_and_image') ? 'active' : ''); ?>">
                              <a href="<?php echo e(route('admin.pages.footer.logo_and_image')); ?>">
                                <span class="sub-item"><?php echo e(__('Logo & Image')); ?></span>
                              </a>
                            </li>

                            <li class="<?php echo e(request()->routeIs('admin.pages.footer.content') ? 'active' : ''); ?>">
                              <a
                                href="<?php echo e(route('admin.pages.footer.content', ['language' => $defaultLang->code])); ?>">
                                <span class="sub-item"><?php echo e(__('Content')); ?></span>
                              </a>
                            </li>
                            <li class="<?php echo e(request()->routeIs('admin.pages.footer.quick_links') ? 'active' : ''); ?>">
                              <a
                                href="<?php echo e(route('admin.pages.footer.quick_links', ['language' => $defaultLang->code])); ?>">
                                <span class="sub-item"><?php echo e(__('Quick Links')); ?></span>
                              </a>
                            </li>
                          </ul>
                        </div>
                      </li>
                      <li class="submenu">
                        <a data-toggle="collapse"
                          href="#Breadcrumb"aria-expanded="<?php echo e(request()->routeIs('admin.pages.breadcrumb.image') || request()->routeIs('admin.pages.breadcrumb.headings') ? 'true' : 'false'); ?>">
                          <span class="sub-item"><?php echo e(__('Breadcrumb')); ?></span>
                          <span class="caret"></span>
                        </a>
                        <div id="Breadcrumb"
                          class="collapse 
                    <?php if(request()->routeIs('admin.pages.breadcrumb.image')): ?> show 
                    <?php elseif(request()->routeIs('admin.pages.breadcrumb.headings')): ?> show <?php endif; ?>">
                          <ul class="nav nav-collapse subnav">
                            <li class="<?php echo e(request()->routeIs('admin.pages.breadcrumb.image') ? 'active' : ''); ?>">
                              <a href="<?php echo e(route('admin.pages.breadcrumb.image')); ?>">
                                <span class="sub-item"><?php echo e(__('Image')); ?></span>
                              </a>
                            </li>

                            <li class="<?php echo e(request()->routeIs('admin.pages.breadcrumb.headings') ? 'active' : ''); ?>">
                              <a
                                href="<?php echo e(route('admin.pages.breadcrumb.headings', ['language' => $defaultLang->code])); ?>">
                                <span class="sub-item"><?php echo e(__('Headings')); ?></span>
                              </a>
                            </li>
                          </ul>
                        </div>
                      </li>
                    </ul>
                  </div>
                </li>

                
                <li class="<?php echo e(request()->routeIs('admin.pages.faq_management') ? 'active' : ''); ?>">
                  <a href="<?php echo e(route('admin.pages.faq_management', ['language' => $defaultLang->code])); ?>">
                    <span class="sub-item"><?php echo e(__('FAQs')); ?></span>
                  </a>
                </li>
                
                <li class="submenu">
                  <a data-toggle="collapse" href="#blog-page"
                    aria-expanded="<?php echo e(request()->routeIs('admin.pages.blog.categories') ||
                    request()->routeIs('admin.pages.blog.blogs') ||
                    request()->routeIs('admin.pages.blog.create_blog') ||
                    request()->routeIs('admin.pages.blog.edit_blog')
                        ? 'true'
                        : 'false'); ?>">
                    <span class="sub-item"><?php echo e(__('Blog')); ?></span>
                    <span class="caret"></span>
                  </a>
                  <div id="blog-page"
                    class="collapse
                    <?php if(request()->routeIs('admin.pages.blog.categories') ||
                            request()->routeIs('admin.pages.blog.create_blog') ||
                            request()->routeIs('admin.pages.blog.edit_blog') ||
                            request()->routeIs('admin.pages.blog.blogs')): ?> show <?php endif; ?>">
                    <ul class="nav nav-collapse subnav">
                      <li class="<?php echo e(request()->routeIs('admin.pages.blog.categories') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.pages.blog.categories', ['language' => $defaultLang->code])); ?>">
                          <span class="sub-item"><?php echo e(__('Categories')); ?></span>
                        </a>
                      </li>

                      <li
                        class="<?php echo e(request()->routeIs('admin.pages.blog.blogs') || request()->routeIs('admin.pages.blog.create_blog') || request()->routeIs('admin.pages.blog.edit_blog') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.pages.blog.blogs', ['language' => $defaultLang->code])); ?>">
                          <span class="sub-item"><?php echo e(__('Posts')); ?></span>
                        </a>
                      </li>
                    </ul>
                  </div>
                </li>
                
                <li class="<?php echo e(request()->routeIs('admin.pages.contact_page') ? 'active' : ''); ?>">
                  <a href="<?php echo e(route('admin.pages.contact_page')); ?>">
                    <span class="sub-item"><?php echo e(__('Contact Page')); ?></span>
                  </a>
                </li>
                
                <li class="submenu">
                  <a data-toggle="collapse" href="#Additional-page"
                    aria-expanded="<?php echo e(request()->routeIs('admin.pages.additional_pages') ||
                    request()->routeIs('admin.pages.additional_pages.create_page') ||
                    request()->routeIs('admin.pages.additional_pages.edit_page')
                        ? 'true'
                        : 'false'); ?>">
                    <span class="sub-item"><?php echo e(__('Additional Pages')); ?></span>
                    <span class="caret"></span>
                  </a>
                  <div id="Additional-page"
                    class="collapse
                    <?php if(request()->routeIs('admin.pages.additional_pages') ||
                            request()->routeIs('admin.pages.additional_pages.create_page') ||
                            request()->routeIs('admin.pages.additional_pages.edit_page')): ?> show <?php endif; ?>">
                    <ul class="nav nav-collapse subnav">
                      <li
                        class="<?php echo e(request()->routeIs('admin.pages.additional_pages') || request()->routeIs('admin.pages.additional_pages.edit_page') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.pages.additional_pages', ['language' => $defaultLang->code])); ?>">
                          <span class="sub-item"><?php echo e(__('All Pages')); ?></span>
                        </a>
                      </li>

                      <li
                        class="<?php echo e(request()->routeIs('admin.pages.additional_pages.create_page') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.pages.additional_pages.create_page')); ?>">
                          <span class="sub-item"><?php echo e(__('Add Page')); ?></span>
                        </a>
                      </li>
                    </ul>
                  </div>
                </li>

                

                
                <li class="<?php echo e(request()->routeIs('admin.settings.seo') ? 'active' : ''); ?>">
                  <a href="<?php echo e(route('admin.settings.seo', ['language' => $defaultLang->code])); ?>">
                    <span class="sub-item"><?php echo e(__('SEO Informations')); ?></span>
                  </a>
                </li>
              </ul>
            </div>
          </li>
        <?php endif; ?>

        
        <?php if(is_null($roleInfo) || (!empty($rolePermissions) && in_array('Transaction', $rolePermissions))): ?>
          <li class="nav-item <?php if(request()->routeIs('admin.transcation')): ?> active <?php endif; ?>">
            <a href="<?php echo e(route('admin.transcation', ['language' => $defaultLang->code])); ?>">
              <i class="fal fa-exchange-alt"></i>
              <p><?php echo e(__('Transactions')); ?></p>
            </a>
          </li>
        <?php endif; ?>

        
        <?php if(is_null($roleInfo) || (!empty($rolePermissions) && in_array('Support Tickets', $rolePermissions))): ?>
          <li
            class="nav-item <?php if(request()->routeIs('admin.support_ticket.setting')): ?> active
            <?php elseif(request()->routeIs('admin.support_tickets')): ?> active
            <?php elseif(request()->routeIs('admin.support_tickets.message')): ?> active active
            <?php elseif(request()->routeIs('admin.user_management.push_notification.notification_for_visitors')): ?> active <?php endif; ?>">
            <a data-toggle="collapse" href="#support_ticket">
              <i class="la flaticon-web-1"></i>
              <p><?php echo e(__('Support Tickets')); ?></p>
              <span class="caret"></span>
            </a>

            <div id="support_ticket"
              class="collapse
              <?php if(request()->routeIs('admin.support_ticket.setting')): ?> show
              <?php elseif(request()->routeIs('admin.support_tickets')): ?> show
              <?php elseif(request()->routeIs('admin.support_tickets.message')): ?> show <?php endif; ?>">
              <ul class="nav nav-collapse">
                <li class="<?php if(request()->routeIs('admin.support_ticket.setting')): ?> active <?php endif; ?>">
                  <a href="<?php echo e(route('admin.support_ticket.setting')); ?>">
                    <span class="sub-item"><?php echo e(__('Settings')); ?></span>
                  </a>
                </li>
                <li
                  class="<?php echo e(request()->routeIs('admin.support_tickets') && empty(request()->input('status')) ? 'active' : ''); ?>">
                  <a href="<?php echo e(route('admin.support_tickets')); ?>">
                    <span class="sub-item"><?php echo e(__('All Tickets')); ?></span>
                  </a>
                </li>
                <li
                  class="<?php echo e(request()->routeIs('admin.support_tickets') && request()->input('status') == 1 ? 'active' : ''); ?>">
                  <a href="<?php echo e(route('admin.support_tickets', ['status' => 1])); ?>">
                    <span class="sub-item"><?php echo e(__('Pending Tickets')); ?></span>
                  </a>
                </li>
                <li
                  class="<?php echo e(request()->routeIs('admin.support_tickets') && request()->input('status') == 2 ? 'active' : ''); ?>">
                  <a href="<?php echo e(route('admin.support_tickets', ['status' => 2])); ?>">
                    <span class="sub-item"><?php echo e(__('Open Tickets')); ?></span>
                  </a>
                </li>
                <li
                  class="<?php echo e(request()->routeIs('admin.support_tickets') && request()->input('status') == 3 ? 'active' : ''); ?>">
                  <a href="<?php echo e(route('admin.support_tickets', ['status' => 3])); ?>">
                    <span class="sub-item"><?php echo e(__('Closed Tickets')); ?></span>
                  </a>
                </li>
              </ul>
            </div>
          </li>
        <?php endif; ?>

        
        <?php if(is_null($roleInfo) || (!empty($rolePermissions) && in_array('Advertisements', $rolePermissions))): ?>
          <li
            class="nav-item <?php if(request()->routeIs('admin.advertise.settings')): ?> active 
            <?php elseif(request()->routeIs('admin.advertise.all_advertisement')): ?> active <?php endif; ?>">
            <a data-toggle="collapse" href="#customid">
              <i class="fab fa-buysellads"></i>
              <p><?php echo e(__('Advertisements')); ?></p>
              <span class="caret"></span>
            </a>

            <div id="customid"
              class="collapse <?php if(request()->routeIs('admin.advertise.settings')): ?> show 
              <?php elseif(request()->routeIs('admin.advertise.all_advertisement')): ?> show <?php endif; ?>">
              <ul class="nav nav-collapse">
                <li class="<?php echo e(request()->routeIs('admin.advertise.settings') ? 'active' : ''); ?>">
                  <a href="<?php echo e(route('admin.advertise.settings', ['language' => $defaultLang->code])); ?>">
                    <span class="sub-item"><?php echo e(__('Settings')); ?></span>
                  </a>
                </li>

                <li class="<?php echo e(request()->routeIs('admin.advertise.all_advertisement') ? 'active' : ''); ?>">
                  <a href="<?php echo e(route('admin.advertise.all_advertisement', ['language' => $defaultLang->code])); ?>">
                    <span class="sub-item"><?php echo e(__('All Advertisements')); ?></span>
                  </a>
                </li>
              </ul>
            </div>
          </li>
        <?php endif; ?>

        
        <?php if(is_null($roleInfo) || (!empty($rolePermissions) && in_array('Announcement Popups', $rolePermissions))): ?>
          <li
            class="nav-item <?php if(request()->routeIs('admin.announcement_popups')): ?> active 
            <?php elseif(request()->routeIs('admin.announcement_popups.select_popup_type')): ?> active 
            <?php elseif(request()->routeIs('admin.announcement_popups.create_popup')): ?> active 
            <?php elseif(request()->routeIs('admin.announcement_popups.edit_popup')): ?> active <?php endif; ?>">
            <a href="<?php echo e(route('admin.announcement_popups', ['language' => $defaultLang->code])); ?>">
              <i class="fal fa-bullhorn"></i>
              <p><?php echo e(__('Announcement Popups')); ?></p>
            </a>
          </li>
        <?php endif; ?>

        
        <?php if(is_null($roleInfo) || (!empty($rolePermissions) && in_array('Settings', $rolePermissions))): ?>
          <li class="nav-item 
            <?php if(request()->routeIs([
                    'admin.pages.contact_page',
                    'admin.settings.mail_from_admin',
                    'admin.settings.mail_to_admin',
                    'admin.settings.mail_templates',
                    'admin.settings.edit_mail_template',
                    'admin.settings.plugins',
                    'admin.settings.payment_gateways.online_gateways',
                    'admin.settings.payment_gateways.offline_gateways',
                    'admin.settings.maintenance_mode',
                    'admin.settings.general_settings',
                    'admin.settings.cookie_alert',
                    'admin.settings.social_medias',
                    'admin.settings.language_management',
                    'admin.settings.language_management.edit_front_keyword',
                    'admin.settings.language_management.edit_admin_keyword',
                ])): ?> active <?php endif; ?>">
            <a data-toggle="collapse" href="#basic_settings">
              <i class="la flaticon-settings"></i>
              <p><?php echo e(__('Settings')); ?></p>
              <span class="caret"></span>
            </a>

            <div id="basic_settings"
              class="collapse 
              <?php if(request()->routeIs([
                      'admin.pages.contact_page',
                      'admin.settings.mail_from_admin',
                      'admin.settings.mail_to_admin',
                      'admin.settings.mail_templates',
                      'admin.settings.edit_mail_template',
                      'admin.settings.plugins',
                      'admin.settings.payment_gateways.online_gateways',
                      'admin.settings.payment_gateways.offline_gateways',
                      'admin.settings.maintenance_mode',
                      'admin.settings.cookie_alert',
                      'admin.settings.general_settings',
                      'admin.settings.social_medias',
                      'admin.settings.language_management',
                      'admin.settings.language_management.edit_front_keyword',
                      'admin.settings.language_management.edit_admin_keyword',
                  ])): ?> show <?php endif; ?>
">
              <ul class="nav nav-collapse">
                <li class="<?php echo e(request()->routeIs('admin.settings.general_settings') ? 'active' : ''); ?>">
                  <a href="<?php echo e(route('admin.settings.general_settings')); ?>">
                    <span class="sub-item"><?php echo e(__('General Settings')); ?></span>
                  </a>
                </li>

                <li class="submenu">
                  <a data-toggle="collapse" href="#mail-settings">
                    <span class="sub-item"><?php echo e(__('Email Settings')); ?></span>
                    <span class="caret"></span>
                  </a>

                  <div id="mail-settings"
                    class="collapse 
                    <?php if(request()->routeIs('admin.settings.mail_from_admin')): ?> show 
                    <?php elseif(request()->routeIs('admin.settings.mail_to_admin')): ?> show
                    <?php elseif(request()->routeIs('admin.settings.mail_templates')): ?> show
                    <?php elseif(request()->routeIs('admin.settings.edit_mail_template')): ?> show <?php endif; ?>">
                    <ul class="nav nav-collapse subnav">
                      <li class="<?php echo e(request()->routeIs('admin.settings.mail_from_admin') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.settings.mail_from_admin')); ?>">
                          <span class="sub-item"><?php echo e(__('Mail From Admin')); ?></span>
                        </a>
                      </li>

                      <li class="<?php echo e(request()->routeIs('admin.settings.mail_to_admin') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.settings.mail_to_admin')); ?>">
                          <span class="sub-item"><?php echo e(__('Mail To Admin')); ?></span>
                        </a>
                      </li>

                      <li
                        class="<?php if(request()->routeIs('admin.settings.mail_templates')): ?> active 
                        <?php elseif(request()->routeIs('admin.settings.edit_mail_template')): ?> active <?php endif; ?>">
                        <a href="<?php echo e(route('admin.settings.mail_templates')); ?>">
                          <span class="sub-item"><?php echo e(__('Mail Templates')); ?></span>
                        </a>
                      </li>
                    </ul>
                  </div>
                </li>

                
                <li class="submenu">
                  <a data-toggle="collapse" href="#payment-gateway"
                    aria-expanded="<?php echo e(request()->routeIs('admin.settings.payment_gateways.online_gateways') || request()->routeIs('admin.settings.payment_gateways.offline_gateways') ? 'true' : 'false'); ?>">
                    <span class="sub-item"><?php echo e(__('Payment Gateways')); ?></span>
                    <span class="caret"></span>
                  </a>

                  <div id="payment-gateway"
                    class="collapse
                    <?php if(request()->routeIs('admin.settings.payment_gateways.online_gateways')): ?> show
                    <?php elseif(request()->routeIs('admin.settings.payment_gateways.offline_gateways')): ?> show <?php endif; ?>">
                    <ul class="nav nav-collapse subnav">
                      <li
                        class="<?php echo e(request()->routeIs('admin.settings.payment_gateways.online_gateways') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.settings.payment_gateways.online_gateways')); ?>">
                          <span class="sub-item"><?php echo e(__('Online Gateways')); ?></span>
                        </a>
                      </li>

                      <li
                        class="<?php echo e(request()->routeIs('admin.settings.payment_gateways.offline_gateways') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.settings.payment_gateways.offline_gateways')); ?>">
                          <span class="sub-item"><?php echo e(__('Offline Gateways')); ?></span>
                        </a>
                      </li>
                    </ul>
                  </div>
                </li>

                
                <li
                  class="<?php if(request()->routeIs('admin.settings.language_management')): ?> active
            <?php elseif(request()->routeIs('admin.settings.language_management.edit_front_keyword')): ?> active 
            <?php elseif(request()->routeIs('admin.settings.language_management.edit_admin_keyword')): ?> active <?php endif; ?>">
                  <a href="<?php echo e(route('admin.settings.language_management')); ?>">
                    <span class="sub-item"><?php echo e(__('Languages')); ?></span>
                  </a>
                </li>

                <li class="<?php echo e(request()->routeIs('admin.settings.plugins') ? 'active' : ''); ?>">
                  <a href="<?php echo e(route('admin.settings.plugins')); ?>">
                    <span class="sub-item"><?php echo e(__('Plugins')); ?></span>
                  </a>
                </li>

                <li class="<?php echo e(request()->routeIs('admin.settings.maintenance_mode') ? 'active' : ''); ?>">
                  <a href="<?php echo e(route('admin.settings.maintenance_mode')); ?>">
                    <span class="sub-item"><?php echo e(__('Maintenance Mode')); ?></span>
                  </a>
                </li>

                <li class="<?php echo e(request()->routeIs('admin.settings.cookie_alert') ? 'active' : ''); ?>">
                  <a href="<?php echo e(route('admin.settings.cookie_alert', ['language' => $defaultLang->code])); ?>">
                    <span class="sub-item"><?php echo e(__('Cookie Alert')); ?></span>
                  </a>
                </li>

                <li class="<?php echo e(request()->routeIs('admin.settings.social_medias') ? 'active' : ''); ?>">
                  <a href="<?php echo e(route('admin.settings.social_medias')); ?>">
                    <span class="sub-item"><?php echo e(__('Social Medias')); ?></span>
                  </a>
                </li>
              </ul>
            </div>
          </li>
        <?php endif; ?>

        
        <?php if(is_null($roleInfo) || (!empty($rolePermissions) && in_array('Staffs Management', $rolePermissions))): ?>
          <li
            class="nav-item <?php if(request()->routeIs('admin.admin_management.role_permissions')): ?> active 
            <?php elseif(request()->routeIs('admin.admin_management.role.permissions')): ?> active 
            <?php elseif(request()->routeIs('admin.admin_management.registered_admins')): ?> active <?php endif; ?>">
            <a data-toggle="collapse" href="#admin">
              <i class="fal fa-users-cog"></i>
              <p><?php echo e(__('Staffs Management')); ?></p>
              <span class="caret"></span>
            </a>

            <div id="admin"
              class="collapse 
              <?php if(request()->routeIs('admin.admin_management.role_permissions')): ?> show 
              <?php elseif(request()->routeIs('admin.admin_management.role.permissions')): ?> show 
              <?php elseif(request()->routeIs('admin.admin_management.registered_admins')): ?> show <?php endif; ?>">
              <ul class="nav nav-collapse">
                <li
                  class="<?php if(request()->routeIs('admin.admin_management.role_permissions')): ?> active 
                  <?php elseif(request()->routeIs('admin.admin_management.role.permissions')): ?> active <?php endif; ?>">
                  <a href="<?php echo e(route('admin.admin_management.role_permissions')); ?>">
                    <span class="sub-item"><?php echo e(__('Role & Permissions')); ?></span>
                  </a>
                </li>
                <li class="<?php echo e(request()->routeIs('admin.admin_management.registered_admins') ? 'active' : ''); ?>">
                  <a href="<?php echo e(route('admin.admin_management.registered_admins')); ?>">
                    <span class="sub-item"><?php echo e(__('Registered Admins')); ?></span>
                  </a>
                </li>
              </ul>
            </div>
          </li>
        <?php endif; ?>
      </ul>
    </div>
  </div>
</div>
<?php /**PATH /Users/samiulalimpratik/Sites/timestay/timestay/resources/views/admin/partials/side-navbar.blade.php ENDPATH**/ ?>