<?php $__env->startSection('pageHeading'); ?>
  <?php echo e(__('404')); ?>

<?php $__env->stopSection(); ?>
<?php
  $basicInfo = App\Models\BasicSettings\Basic::select('breadcrumb', 'theme_version')->firstOrFail();
  $version = $basicInfo->theme_version;

  if (request()->session()->has('currentLocaleCode')) {
      $locale = request()->session()->get('currentLocaleCode');
  }
  if (empty($locale)) {
      // set the default language as system locale
      $languageCode = App\Models\Language::where('is_default', '=', 1)->pluck('code')->first();

      App::setLocale($languageCode);
  } else {
      // set the selected language as system locale
      App::setLocale($locale);
  }
?>


<?php $__env->startSection('content'); ?>
  <?php if ($__env->exists('frontend.partials.breadcrumb', [
      'breadcrumb' => $basicInfo->breadcrumb,
      'title' => __('404'),
  ])) echo $__env->make('frontend.partials.breadcrumb', [
      'breadcrumb' => $basicInfo->breadcrumb,
      'title' => __('404'),
  ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  <!--====== Start Error Section ======-->

  <div class="error-area ptb-100">
    <div class="container">
      <div class="error-content">
        <img class="lazyload" src="assets/images/placeholder.png" data-src="<?php echo e(asset('assets/img/404.svg')); ?>"
          alt="image">
        <h3><?php echo e(__('Ooops! Page Not Found')); ?></h3>
        <p>
          <?php echo e(__('The page you are looking for might have been removed had its name changed or is temporarily unavailable.')); ?>

        </p>
        <a href="<?php echo e(route('index')); ?>" class="btn btn-lg btn-primary radius-sm" title="Back to Home"
          target="_self"><?php echo e(__('Back to Home')); ?></a>
      </div>
    </div>
  </div>
  <!--====== End Error Section ======-->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/samiulalimpratik/Sites/timestay/timestay/resources/views/errors/404.blade.php ENDPATH**/ ?>