 <!-- Header-area start -->
 <header class="header-area header_v1">
   <!-- Start mobile menu -->
   <div class="mobile-menu">
     <div class="container">
       <div class="mobile-menu-wrapper"></div>
     </div>
   </div>
   <!-- End mobile menu -->

   <div class="main-responsive-nav">
     <div class="container">
       <!-- Mobile Logo -->
       <div class="logo">
         <?php if(!empty($websiteInfo->logo)): ?>
           <a href="<?php echo e(route('index')); ?>">
             <img src="<?php echo e(asset('assets/img/' . $websiteInfo->logo)); ?>" alt="logo">
           </a>
         <?php endif; ?>
       </div>
       <!-- Menu toggle button -->
       <button class="menu-toggler" type="button">
         <span></span>
         <span></span>
         <span></span>
       </button>
     </div>
   </div>

   <div class="main-navbar">
     <div class="header-top bg-primary py-15">
       <div class="container">
         <div class="header-left">
           <ul class="contact-list list-unstyled">
             <li class="icon-start">
               <a href="mailto:<?php echo e($basicInfo->email_address); ?>" title="<?php echo e($basicInfo->email_address); ?>">
                 <i class="fal fa-envelope"></i>
                 <?php echo e($basicInfo->email_address); ?>

               </a>
             </li>
             <li class="icon-start">
               <a href="tel:<?php echo e($basicInfo->contact_number); ?>" title="<?php echo e($basicInfo->contact_number); ?>">
                 <i class="fal fa-user-headset"></i><?php echo e($basicInfo->contact_number); ?>

               </a>
             </li>
           </ul>
         </div>
         <div class="header-right">
           <div class="more-option mobile-item">
             <div class="item">
               <div class="dropdown">
                 <button class="btn-icon-text size-auto dropdown-toggle" type="button" data-bs-toggle="dropdown"
                   aria-expanded="false">
                   <i class="fal fa-user-circle"></i>
                   <span>
                     <?php if(!Auth::guard('web')->check()): ?>
                       <?php echo e(__('Customer')); ?>

                     <?php else: ?>
                       <?php echo e(Auth::guard('web')->user()->username); ?>

                     <?php endif; ?>
                   </span>
                 </button>
                 <ul class="dropdown-menu">
                   <?php if(!Auth::guard('web')->check()): ?>
                     <li><a class="dropdown-item" href="<?php echo e(route('user.login')); ?>"><?php echo e(__('Login')); ?></a></li>
                     <li><a class="dropdown-item" href="<?php echo e(route('user.signup')); ?>"><?php echo e(__('Signup')); ?></a></li>
                   <?php else: ?>
                     <li><a class="dropdown-item" href="<?php echo e(route('user.dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a></li>
                     <li><a class="dropdown-item" href="<?php echo e(route('user.logout')); ?>"><?php echo e(__('Logout')); ?></a></li>
                   <?php endif; ?>
                 </ul>
               </div>
             </div>
             <div class="item">
               <div class="dropdown">
                 <button class="btn-icon-text size-auto dropdown-toggle" type="button" data-bs-toggle="dropdown"
                   aria-expanded="false">
                   <i class="fa fa-hotel"></i>
                   <span><?php echo e(__('Vendor')); ?></span>
                 </button>
                 <ul class="dropdown-menu">
                   <?php if(!Auth::guard('vendor')->check()): ?>
                     <li><a class="dropdown-item" href="<?php echo e(route('vendor.login')); ?>"><?php echo e(__('Login')); ?></a></li>
                     <li><a class="dropdown-item" href="<?php echo e(route('vendor.signup')); ?>"><?php echo e(__('Signup')); ?></a></li>
                   <?php else: ?>
                     <li><a class="dropdown-item" href="<?php echo e(route('vendor.dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a>
                     </li>

                     <li><a class="dropdown-item" href="<?php echo e(route('vendor.logout')); ?>"><?php echo e(__('Logout')); ?></a></li>
                   <?php endif; ?>
                 </ul>
               </div>
             </div>
           </div>
         </div>
       </div>
     </div>
     <div class="header-bottom">
       <div class="container">
         <nav class="navbar navbar-expand-lg">
           <!-- Logo -->
           <a class="navbar-brand" href="<?php echo e(route('index')); ?>">
             <img src="<?php echo e(asset('assets/img/' . $websiteInfo->logo)); ?>" alt="logo">
           </a>
           <!-- Navigation items -->
           <div class="collapse navbar-collapse">
             <?php $menuDatas = json_decode($menuInfos); ?>
             <ul id="mainMenu" class="navbar-nav mobile-item mx-auto">
               <?php $__currentLoopData = $menuDatas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $menuData): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                 <?php $href = get_href($menuData); ?>
                 <?php if(!property_exists($menuData, 'children')): ?>
                   <li class="nav-item">
                     <a class="nav-link" href="<?php echo e($href); ?>"><?php echo e($menuData->text); ?></a>
                   </li>
                 <?php else: ?>
                   <li class="nav-item">
                     <a class="nav-link toggle" href="<?php echo e($href); ?>"><?php echo e($menuData->text); ?><i
                         class="fal fa-plus"></i></a>
                     <ul class="menu-dropdown">
                       <?php $childMenuDatas = $menuData->children; ?>
                       <?php $__currentLoopData = $childMenuDatas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $childMenuData): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                         <?php $child_href = get_href($childMenuData); ?>
                         <li class="nav-item">
                           <a class="nav-link" href="<?php echo e($child_href); ?>"><?php echo e($childMenuData->text); ?></a>
                         </li>
                       <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                     </ul>
                   </li>
                 <?php endif; ?>
               <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
             </ul>
           </div>
           <div class="more-option mobile-item">
             <div class="item">
               <div class="language">
                 <form action="<?php echo e(route('change_language')); ?>" method="GET">
                   <select class="niceselect" name="lang_code" onchange="this.form.submit()">
                     <?php $__currentLoopData = $allLanguageInfos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $languageInfo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                       <option value="<?php echo e($languageInfo->code); ?>"
                         <?php echo e($languageInfo->code == $currentLanguageInfo->code ? 'selected' : ''); ?>>
                         <?php echo e($languageInfo->name); ?>

                       </option>
                     <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                   </select>
                 </form>
               </div>
             </div>
           </div>
         </nav>
       </div>
     </div>
   </div>
 </header>
 <!-- Header-area end -->
<?php /**PATH /Users/samiulalimpratik/Sites/timestay/timestay/resources/views/frontend/partials/header/header-v1.blade.php ENDPATH**/ ?>